import { useEnv } from '@directus/env';
import { getDatabaseVersion } from '../../../index.js';
import { SchemaHelper } from '../types.js';
const env = useEnv();
export class SchemaHelperMySQL extends SchemaHelper {
    applyMultiRelationalSort(knex, dbQuery, table, primaryKey, orderByString, orderByFields) {
        if (getDatabaseVersion()?.startsWith('5.7')) {
            dbQuery.orderByRaw(`?? asc, ${orderByString}`, [`${table}.${primaryKey}`, ...orderByFields]);
            dbQuery = knex
                .select(knex.raw(`??, ( @rank := IF ( @cur_id = deep.${primaryKey}, @rank + 1, 1 ) ) AS directus_row_number, ( @cur_id := deep.${primaryKey} ) AS current_id`, 'deep.*'))
                .from(knex.raw('? as ??, (SELECT @rank := 0,  @cur_id := null) vars', [dbQuery, 'deep']));
            return dbQuery;
        }
        return super.applyMultiRelationalSort(knex, dbQuery, table, primaryKey, orderByString, orderByFields);
    }
    async getDatabaseSize() {
        try {
            const result = (await this.knex
                .sum('size AS size')
                .from(this.knex
                .select(this.knex.raw('data_length + index_length AS size'))
                .from('information_schema.TABLES')
                .where('table_schema', '=', String(env['DB_DATABASE']))
                .as('size')));
            return result[0]?.['size'] ? Number(result[0]?.['size']) : null;
        }
        catch {
            return null;
        }
    }
}
