import { toBoolean } from '@directus/utils';
import {} from './get-user-count.js';
/**
 * Get the role type counts by role IDs
 */
export async function getRoleCountsByRoles(db, roles) {
    const counts = {
        admin: 0,
        app: 0,
        api: 0,
    };
    const result = (await db.select('id', 'admin_access', 'app_access').from('directus_roles').whereIn('id', roles));
    for (const role of result) {
        const adminAccess = toBoolean(role.admin_access);
        const appAccess = toBoolean(role.app_access);
        if (adminAccess) {
            counts.admin++;
        }
        else if (appAccess) {
            counts.app++;
        }
        else {
            counts.api++;
        }
    }
    return counts;
}
