"use strict";
// tar -u
Object.defineProperty(exports, "__esModule", { value: true });
exports.update = void 0;
const options_js_1 = require("./options.js");
const replace_js_1 = require("./replace.js");
// just call tar.r with the filter and mtimeCache
const update = (opt_, files, cb) => {
    const opt = (0, options_js_1.dealias)(opt_);
    if (!(0, options_js_1.isFile)(opt)) {
        throw new TypeError('file is required');
    }
    if (opt.gzip ||
        opt.brotli ||
        opt.file.endsWith('.br') ||
        opt.file.endsWith('.tbr')) {
        throw new TypeError('cannot append to compressed archives');
    }
    if (!files || !Array.isArray(files) || !files.length) {
        throw new TypeError('no files or directories specified');
    }
    files = Array.from(files);
    mtimeFilter(opt);
    return (0, replace_js_1.replace)(opt, files, cb);
};
exports.update = update;
const mtimeFilter = (opt) => {
    const filter = opt.filter;
    if (!opt.mtimeCache) {
        opt.mtimeCache = new Map();
    }
    opt.filter =
        filter ?
            (path, stat) => filter(path, stat) &&
                !(
                /* c8 ignore start */
                ((opt.mtimeCache?.get(path) ?? stat.mtime ?? 0) >
                    (stat.mtime ?? 0))
                /* c8 ignore stop */
                )
            : (path, stat) => !(
            /* c8 ignore start */
            ((opt.mtimeCache?.get(path) ?? stat.mtime ?? 0) >
                (stat.mtime ?? 0))
            /* c8 ignore stop */
            );
};
//# sourceMappingURL=update.js.map