/// <reference types="node" />
import EventEmitter from 'events';
import { type ClearOutput, type DeleteOutput, type DisconnectOutput, type GetManyOutput, type GetOutput, type HasOutput, type IteratorOutput, type KeyvRedisOptions, type KeyvUriOptions, type SetOutput } from './types';
declare class KeyvRedis<Value = any> extends EventEmitter {
    ttlSupport: boolean;
    namespace?: string;
    opts: Record<string, unknown>;
    redis: any;
    constructor(uri: KeyvRedisOptions | KeyvUriOptions, options?: KeyvRedisOptions);
    _getNamespace(): string;
    _getKeyName: (key: string) => string;
    get(key: string): GetOutput<Value>;
    getMany(keys: string[]): GetManyOutput<Value>;
    set(key: string, value: Value, ttl?: number): SetOutput;
    delete(key: string): DeleteOutput;
    deleteMany(keys: string[]): DeleteOutput;
    clear(): ClearOutput;
    iterator(namespace?: string): IteratorOutput;
    has(key: string): HasOutput;
    disconnect(): DisconnectOutput;
}
export = KeyvRedis;
