"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Get = exports.Set = exports.Has = exports.Delete = exports.Clear = exports.Entries = void 0;
/** A registry for user defined string formats */
const map = new Map();
/** Returns the entries in this registry */
function Entries() {
    return new Map(map);
}
exports.Entries = Entries;
/** Clears all user defined string formats */
function Clear() {
    return map.clear();
}
exports.Clear = Clear;
/** Deletes a registered format */
function Delete(format) {
    return map.delete(format);
}
exports.Delete = Delete;
/** Returns true if the user defined string format exists */
function Has(format) {
    return map.has(format);
}
exports.Has = Has;
/** Sets a validation function for a user defined string format */
function Set(format, func) {
    map.set(format, func);
}
exports.Set = Set;
/** Gets a validation function for a user defined string format */
function Get(format) {
    return map.get(format);
}
exports.Get = Get;
