"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Mutate = exports.Patch = exports.Hash = exports.Diff = exports.Equal = exports.Errors = exports.Encode = exports.Default = exports.Decode = exports.Clone = exports.Convert = exports.Clean = exports.Check = exports.Create = exports.Cast = void 0;
const index_1 = require("../transform/index");
const index_2 = require("../mutate/index");
const index_3 = require("../hash/index");
const index_4 = require("../equal/index");
const index_5 = require("../cast/index");
const index_6 = require("../clone/index");
const index_7 = require("../convert/index");
const index_8 = require("../create/index");
const index_9 = require("../clean/index");
const index_10 = require("../check/index");
const index_11 = require("../default/index");
const index_12 = require("../delta/index");
const index_13 = require("../../errors/index");
/** Casts a value into a given type. The return value will retain as much information of the original value as possible. */
function Cast(...args) {
    return index_5.Cast.apply(index_5.Cast, args);
}
exports.Cast = Cast;
/** Creates a value from the given type */
function Create(...args) {
    return index_8.Create.apply(index_8.Create, args);
}
exports.Create = Create;
/** Returns true if the value matches the given type */
function Check(...args) {
    return index_10.Check.apply(index_10.Check, args);
}
exports.Check = Check;
/** `[Mutable]` Removes excess properties from a value and returns the result. This function does not check the value and returns an unknown type. You should Check the result before use. Clean is a mutable operation. To avoid mutation, Clone the value first. */
function Clean(...args) {
    return index_9.Clean.apply(index_9.Clean, args);
}
exports.Clean = Clean;
/** Converts any type mismatched values to their target type if a reasonable conversion is possible. */
function Convert(...args) {
    return index_7.Convert.apply(index_7.Convert, args);
}
exports.Convert = Convert;
/** Returns a structural clone of the given value */
function Clone(value) {
    return (0, index_6.Clone)(value);
}
exports.Clone = Clone;
/** Decodes a value or throws if error */
function Decode(...args) {
    const [schema, references, value] = args.length === 3 ? [args[0], args[1], args[2]] : [args[0], [], args[1]];
    if (!Check(schema, references, value))
        throw new index_1.TransformDecodeCheckError(schema, value, Errors(schema, references, value).First());
    return (0, index_1.HasTransform)(schema, references) ? (0, index_1.TransformDecode)(schema, references, value) : value;
}
exports.Decode = Decode;
/** `[Mutable]` Generates missing properties on a value using default schema annotations if available. This function does not check the value and returns an unknown type. You should Check the result before use. Default is a mutable operation. To avoid mutation, Clone the value first. */
function Default(...args) {
    return index_11.Default.apply(index_11.Default, args);
}
exports.Default = Default;
/** Encodes a value or throws if error */
function Encode(...args) {
    const [schema, references, value] = args.length === 3 ? [args[0], args[1], args[2]] : [args[0], [], args[1]];
    const encoded = (0, index_1.HasTransform)(schema, references) ? (0, index_1.TransformEncode)(schema, references, value) : value;
    if (!Check(schema, references, encoded))
        throw new index_1.TransformEncodeCheckError(schema, encoded, Errors(schema, references, encoded).First());
    return encoded;
}
exports.Encode = Encode;
/** Returns an iterator for each error in this value. */
function Errors(...args) {
    return index_13.Errors.apply(index_13.Errors, args);
}
exports.Errors = Errors;
/** Returns true if left and right values are structurally equal */
function Equal(left, right) {
    return (0, index_4.Equal)(left, right);
}
exports.Equal = Equal;
/** Returns edits to transform the current value into the next value */
function Diff(current, next) {
    return (0, index_12.Diff)(current, next);
}
exports.Diff = Diff;
/** Returns a FNV1A-64 non cryptographic hash of the given value */
function Hash(value) {
    return (0, index_3.Hash)(value);
}
exports.Hash = Hash;
/** Returns a new value with edits applied to the given value */
function Patch(current, edits) {
    return (0, index_12.Patch)(current, edits);
}
exports.Patch = Patch;
/** `[Mutable]` Performs a deep mutable value assignment while retaining internal references. */
function Mutate(current, next) {
    (0, index_2.Mutate)(current, next);
}
exports.Mutate = Mutate;
