/*!
 * Axios Cache Interceptor 1.5.2
 * (c) 2021-present Arthur Fiorette & Contributors
 * Released under the MIT License.
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("cache-parser"),require("fast-defer"),require("object-code")):"function"==typeof define&&define.amd?define(["exports","cache-parser","fast-defer","object-code"],t):t((e||self).axiosCacheInterceptor={},e.cacheParser,e.fastDefer,e.objectCode)}(this,function(e,t,r,n){var a=Object.freeze({IfModifiedSince:"if-modified-since",LastModified:"last-modified",IfNoneMatch:"if-none-match",CacheControl:"cache-control",Pragma:"pragma",ETag:"etag",Expires:"expires",Age:"age",XAxiosCacheEtag:"x-axios-cache-etag",XAxiosCacheLastModified:"x-axios-cache-last-modified",XAxiosCacheStaleIfError:"x-axios-cache-stale-if-error"}),i=function(e){if(!e)return"not enough headers";var r=e[a.CacheControl];if(r){var n=t.parse(String(r)),i=n.maxAge,o=n.maxStale,c=n.staleWhileRevalidate;if(n.noCache||n.noStore)return"dont cache";if(n.immutable)return{cache:31536e6};if(void 0!==i){var s=e[a.Age];return{cache:s?1e3*(i-Number(s)):1e3*i,stale:void 0!==o?1e3*o:void 0!==c?1e3*c:void 0}}}var u=e[a.Expires];if(u){var d=Date.parse(String(u))-Date.now();return d>=0?{cache:d}:"dont cache"}return"not enough headers"};function o(){return o=Object.assign?Object.assign.bind():function(e){for(var t=1;t<arguments.length;t++){var r=arguments[t];for(var n in r)Object.prototype.hasOwnProperty.call(r,n)&&(e[n]=r[n])}return e},o.apply(this,arguments)}function c(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function s(e,t){var r="undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(r)return(r=r.call(e)).next.bind(r);if(Array.isArray(e)||(r=function(e,t){if(e){if("string"==typeof e)return c(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);return"Object"===r&&e.constructor&&(r=e.constructor.name),"Map"===r||"Set"===r?Array.from(e):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?c(e,t):void 0}}(e))||t&&e&&"number"==typeof e.length){r&&(e=r);var n=0;return function(){return n>=e.length?{done:!0}:{done:!1,value:e[n++]}}}throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}function u(e){return e?function(t){return e(t)||304===t}:function(e){return e>=200&&e<300||304===e}}function d(e,t){return void 0===e&&(e="get"),void 0===t&&(t=[]),e=e.toLowerCase(),t.some(function(t){return t===e})}function f(e,t){t.headers||(t.headers={});var r=t.cache,n=r.etag,i=r.modifiedSince;if(n){var o,c=!0===n?null==(o=e.data)?void 0:o.headers[a.ETag]:n;c&&(t.headers[a.IfNoneMatch]=c)}i&&(t.headers[a.IfModifiedSince]=!0===i?e.data.headers[a.LastModified]||new Date(e.createdAt).toUTCString():i.toUTCString())}function h(e,t){return 304===e.status&&t?(e.cached=!0,e.data=t.data,e.status=t.status,e.statusText=t.statusText,e.headers=o({},t.headers,e.headers),t):{data:e.data,status:e.status,statusText:e.statusText,headers:e.headers}}function l(e){var t=function t(n){try{if(n.id=e.generateKey(n),!1===n.cache)return e.debug({id:n.id,msg:"Ignoring cache because config.cache === false",data:n}),Promise.resolve(n);if(n.cache=o({},e.defaults.cache,n.cache),"object"==typeof n.cache.cachePredicate&&n.cache.cachePredicate.ignoreUrls&&n.url)for(var i,c=s(n.cache.cachePredicate.ignoreUrls);!(i=c()).done;){var h=i.value;if(h instanceof RegExp?(h.lastIndex=0,h.test(n.url)):n.url.includes(h))return e.debug({id:n.id,msg:"Ignored because url ("+n.url+") matches ignoreUrls ("+n.cache.cachePredicate.ignoreUrls+")",data:{url:n.url,cachePredicate:n.cache.cachePredicate}}),Promise.resolve(n)}var l,v,g,m,p,b;return n.cache.cacheTakeover&&(null!=(l=n.headers)[v=a.CacheControl]||(l[v]="no-cache"),null!=(g=n.headers)[m=a.Pragma]||(g[m]="no-cache"),null!=(p=n.headers)[b=a.Expires]||(p[b]="0")),d(n.method,n.cache.methods)?Promise.resolve(e.storage.get(n.id,n)).then(function(a){var i;function o(r){var o,c;if(i)return r;function s(t){return o?t:(n.transformResponse=void 0,n.adapter=function(){return Promise.resolve({config:n,data:c.data,headers:c.headers,status:c.status,statusText:c.statusText,cached:!0,id:n.id})},e.debug({id:n.id,msg:"Returning cached response"}),n)}var u=function(){if("loading"===a.state){var r=function(r){return o?r:(e.debug({id:n.id,msg:"Detected concurrent request, waiting for it to finish"}),function(e,t){try{var r=Promise.resolve(i).then(function(e){c=e})}catch(e){return t(e)}return r&&r.then?r.then(void 0,t):r}(0,function(r){function i(){var e=t(n);return o=1,e}e.debug({id:n.id,msg:"Deferred rejected, requesting again",data:r});var c=function(){if(a.data)return Promise.resolve(null==n.cache.hydrate?void 0:n.cache.hydrate(a)).then(function(){})}();return c&&c.then?c.then(i):i()}))},i=e.waiting[n.id],s=function(){if(!i){var e=function(){return o=1,n},t=function(){if(a.data)return Promise.resolve(null==n.cache.hydrate?void 0:n.cache.hydrate(a)).then(function(){})}();return t&&t.then?t.then(e):e()}}();return s&&s.then?s.then(r):r(s)}c=a.data}();return u&&u.then?u.then(s):s(u)}var c=n.cache.override,s=function(){if("empty"===a.state||"stale"===a.state||"must-revalidate"===a.state||c){var t=function(){return e.waiting[n.id]=r.deferred(),e.waiting[n.id].catch(function(){}),Promise.resolve(e.storage.set(n.id,{state:"loading",previous:c?a.data?"stale":"empty":a.state,data:a.data,createdAt:c&&!a.createdAt?Date.now():a.createdAt},n)).then(function(){function t(){return i=1,n}"stale"!==a.state&&"must-revalidate"!==a.state||(f(a,n),e.debug({id:n.id,msg:"Updated stale request"})),n.validateStatus=u(n.validateStatus),e.debug({id:n.id,msg:"Sending request, waiting for response",data:{overrideCache:c,state:a.state}});var r=function(){if("stale"===a.state||a.data&&"must-revalidate"!==a.state)return Promise.resolve(null==n.cache.hydrate?void 0:n.cache.hydrate(a)).then(function(){})}();return r&&r.then?r.then(t):t()})},o=function(){if(e.waiting[n.id]&&!c)return Promise.resolve(e.storage.get(n.id,n)).then(function(t){"empty"!==(a=t).state&&"must-revalidate"!==a.state&&e.debug({id:n.id,msg:"Waiting list had an deferred for this key, waiting for it to finish"})})}();return o&&o.then?o.then(t):t()}}();return s&&s.then?s.then(o):o(s)}):(e.debug({id:n.id,msg:"Ignored because method ("+n.method+") is not in cache.methods ("+n.cache.methods+")"}),Promise.resolve(n))}catch(e){return Promise.reject(e)}};return{onFulfilled:t,apply:function(){return e.interceptors.request.use(t)}}}const v="undefined"!=typeof Symbol?Symbol.iterator||(Symbol.iterator=Symbol("Symbol.iterator")):"@@iterator";function g(e,t,r){if(!e.s){if(r instanceof m){if(!r.s)return void(r.o=g.bind(null,e,t));1&t&&(t=r.s),r=r.v}if(r&&r.then)return void r.then(g.bind(null,e,t),g.bind(null,e,2));e.s=t,e.v=r;var n=e.o;n&&n(e)}}var m=/*#__PURE__*/function(){function e(){}return e.prototype.then=function(t,r){var n=new e,a=this.s;if(a){var i=1&a?t:r;if(i){try{g(n,1,i(this.v))}catch(e){g(n,2,e)}return n}return this}return this.o=function(e){try{var a=e.v;1&e.s?g(n,1,t?t(a):a):r?g(n,1,r(a)):g(n,2,a)}catch(e){g(n,2,e)}},n},e}();function p(e){return e instanceof m&&1&e.s}var b=function(e,t){try{var r=function(t){function r(r){var o;if(n&&!t||a&&!r)return!1;var c=function(){if(i)return function(e,t,r){if("function"==typeof e[v]){var n,a,i,o=e[v]();if(function e(c){try{for(;!((n=o.next()).done||r&&r());)if((c=t(n.value))&&c.then){if(!p(c))return void c.then(e,i||(i=g.bind(null,a=new m,2)));c=c.v}a?g(a,1,c):a=c}catch(e){g(a||(a=new m),2,e)}}(),o.return){var c=function(e){try{n.done||o.return()}catch(e){}return e};if(a&&a.then)return a.then(c,function(e){throw c(e)});c()}return a}if(!("length"in e))throw new TypeError("Object is not iterable");for(var s=[],u=0;u<e.length;u++)s.push(e[u]);return function(e,t,r){var n,a,i=-1;return function o(c){try{for(;++i<e.length&&(!r||!r());)if((c=t(i))&&c.then){if(!p(c))return void c.then(o,a||(a=g.bind(null,n=new m,2)));c=c.v}n?g(n,1,c):n=c}catch(e){g(n||(n=new m),2,e)}}(),n}(s,function(e){return t(s[e])},r)}(Object.entries(i),function(t){var r,n=t[0];return Promise.resolve((0,t[1])(null!=(r=e.headers[n.toLowerCase()])?r:e.headers[n])).then(function(e){if(!e)return o=1,!1})},function(){return o})}();return c&&c.then?c.then(function(e){return!o||e}):!o||c}return n&&!t||!a?r(n&&!t||a&&a(e)):Promise.resolve(n&&!t||a&&a(e)).then(r)};if("function"==typeof t)return Promise.resolve(t(e));var n=t.statusCheck,a=t.responseMatch,i=t.containsHeaders;return Promise.resolve(n?Promise.resolve(n(e.status)).then(r):r(n))}catch(e){return Promise.reject(e)}};const y="undefined"!=typeof Symbol?Symbol.iterator||(Symbol.iterator=Symbol("Symbol.iterator")):"@@iterator";function P(e,t,r){if(!e.s){if(r instanceof w){if(!r.s)return void(r.o=P.bind(null,e,t));1&t&&(t=r.s),r=r.v}if(r&&r.then)return void r.then(P.bind(null,e,t),P.bind(null,e,2));e.s=t,e.v=r;var n=e.o;n&&n(e)}}var w=/*#__PURE__*/function(){function e(){}return e.prototype.then=function(t,r){var n=new e,a=this.s;if(a){var i=1&a?t:r;if(i){try{P(n,1,i(this.v))}catch(e){P(n,2,e)}return n}return this}return this.o=function(e){try{var a=e.v;1&e.s?P(n,1,t?t(a):a):r?P(n,1,r(a)):P(n,2,a)}catch(e){P(n,2,e)}},n},e}();function S(e){return e instanceof w&&1&e.s}var I=function(e,t,r){try{if("function"==typeof r)return Promise.resolve(r(t));var n=function(e,t,r){if("function"==typeof e[y]){var n,a,i,o=e[y]();if(function e(r){try{for(;!(n=o.next()).done;)if((r=t(n.value))&&r.then){if(!S(r))return void r.then(e,i||(i=P.bind(null,a=new w,2)));r=r.v}a?P(a,1,r):a=r}catch(e){P(a||(a=new w),2,e)}}(),o.return){var c=function(e){try{n.done||o.return()}catch(e){}return e};if(a&&a.then)return a.then(c,function(e){throw c(e)});c()}return a}if(!("length"in e))throw new TypeError("Object is not iterable");for(var s=[],u=0;u<e.length;u++)s.push(e[u]);return function(e,t,r){var n,a,i=-1;return function r(o){try{for(;++i<e.length;)if((o=t(i))&&o.then){if(!S(o))return void o.then(r,a||(a=P.bind(null,n=new w,2)));o=o.v}n?P(n,1,o):n=o}catch(e){P(n||(n=new w),2,e)}}(),n}(s,function(e){return t(s[e])})}(Object.entries(r),function(r){var n=r[0],a=r[1];function i(){return Promise.resolve(e.get(n,t.config)).then(function(r){if("loading"!==r.state)return Promise.resolve(a(r,t)).then(function(r){function a(){var a=function(){if("ignore"!==r)return Promise.resolve(e.set(n,r,t.config)).then(function(){})}();if(a&&a.then)return a.then(function(){})}var i=function(){if("delete"===r)return Promise.resolve(e.remove(n,t.config)).then(function(){})}();return i&&i.then?i.then(a):a()})})}var o=function(){if("delete"===a)return Promise.resolve(e.remove(n,t.config)).then(function(){})}();return o&&o.then?o.then(i):i()});return Promise.resolve(n&&n.then?n.then(function(){}):void 0)}catch(e){return Promise.reject(e)}};function C(e){var r=function(t,r){try{return Promise.resolve(e.storage.remove(t,r)).then(function(){var r;null==(r=e.waiting[t])||r.reject(),delete e.waiting[t]})}catch(e){return Promise.reject(e)}},n=function(t){try{var n=function(){return d(i.method,o.methods)?Promise.resolve(e.storage.get(t.id,i)).then(function(n){function c(c){function u(c){var s;function u(r){if(s)return r;function c(){o.staleIfError&&(t.headers[a.XAxiosCacheStaleIfError]=String(g)),e.debug({id:t.id,msg:"Useful response configuration found",data:{cacheConfig:o,cacheResponse:u}});var r={state:"cached",ttl:g,staleTtl:v,createdAt:Date.now(),data:u},n=e.waiting[t.id];return n&&(n.resolve(r.data),delete e.waiting[t.id],e.debug({id:t.id,msg:"Found waiting deferred(s) and resolved them"})),Promise.resolve(e.storage.set(t.id,r,i)).then(function(){return e.debug({id:t.id,msg:"Response cached",data:{cache:r,response:t}}),t})}var u=h(t,n.data),d=function(){if("function"==typeof g)return Promise.resolve(g(t)).then(function(e){g=e})}();return d&&d.then?d.then(c):c()}for(var d=0,f=Object.keys(t.headers);d<f.length;d++){var l=f[d];l.startsWith("x-axios-cache")&&delete t.headers[l]}o.etag&&!0!==o.etag&&(t.headers[a.XAxiosCacheEtag]=o.etag),o.modifiedSince&&(t.headers[a.XAxiosCacheLastModified]=!0===o.modifiedSince?"use-cache-timestamp":o.modifiedSince.toUTCString());var v,g=o.ttl||-1,m=function(){if(o.interpretHeader){var a=function(e){if(s)return e;"not enough headers"!==c&&("number"==typeof c?g=c:(g=c.cache,v=c.stale))},c=e.headerInterpreter(t.headers),u=function(){if("dont cache"===c)return Promise.resolve(r(t.id,i)).then(function(){return e.debug({id:t.id,msg:"Cache header interpreted as 'dont cache'",data:{cache:n,response:t,expirationTime:c}}),s=1,t})}();return u&&u.then?u.then(a):a(u)}}();return m&&m.then?m.then(u):u(m)}var d=function(){if(s&&!c)return Promise.resolve(r(t.id,i)).then(function(){return e.debug({id:t.id,msg:"Cache predicate rejected this response"}),t})}();return d&&d.then?d.then(u):u()}if("loading"!==n.state)return e.debug({id:t.id,msg:"Response not cached and storage isn't loading",data:{cache:n,response:t}}),t;var s=!n.data;return s?Promise.resolve(b(t,o.cachePredicate)).then(c):c(s)}):(e.debug({id:t.id,msg:"Ignored because method ("+i.method+") is not in cache.methods ("+o.methods+")",data:{config:i,cacheConfig:o}}),t)};if(null==t||!t.config)throw e.debug({msg:"Response interceptor received an unknown response.",data:t}),t;t.id=t.config.id,null!=t.cached||(t.cached=!1);var i=t.config,o=i.cache;if(t.cached)return e.debug({id:t.id,msg:"Returned cached response"}),Promise.resolve(t);if(!o)return e.debug({id:t.id,msg:"Response with config.cache falsy",data:t}),t.cached=!1,Promise.resolve(t);var c=function(){if(o.update)return Promise.resolve(I(e.storage,t,o.update)).then(function(){})}();return Promise.resolve(c&&c.then?c.then(n):n())}catch(e){return Promise.reject(e)}},i=function(n){try{var i=function(i){return Promise.resolve(e.storage.get(c,o)).then(function(i){function d(d){var f;function h(t){return f?t:(e.debug({id:c,msg:"Received an unknown error that could not be handled",data:{error:n,config:o}}),Promise.resolve(r(c,o)).then(function(){throw n}))}var l=function(){if(s.staleIfError){var r=function(t){return e.debug({id:c,msg:"Found cache if stale config for rejected response",data:{error:n,config:o,staleIfError:t}}),function(){var r;if(!0===t||"number"==typeof t&&i.createdAt+t>Date.now())return null==(r=e.waiting[c])||r.resolve(i.data),delete e.waiting[c],Promise.resolve(e.storage.set(c,{state:"stale",createdAt:Date.now(),data:i.data},o)).then(function(){return e.debug({id:c,msg:"staleIfError resolved this response with cached data",data:{error:n,config:o,cache:i}}),f=1,{cached:!0,config:o,id:c,data:i.data.data,headers:i.data.headers,status:i.data.status,statusText:i.data.statusText}})}()},d=String(null==u?void 0:u.headers[a.CacheControl]),h=d&&t.parse(d).staleIfError;return"function"==typeof s.staleIfError?Promise.resolve(s.staleIfError(u,i,n)).then(r):r(!0===s.staleIfError&&h?1e3*h:s.staleIfError)}}();return l&&l.then?l.then(h):h(l)}var f=function(){if("loading"!==i.state||"stale"!==i.previous)return e.debug({id:c,msg:"Caught an error in the request interceptor",data:{cache:i,error:n,config:o}}),Promise.resolve(r(c,o)).then(function(){throw n})}();return f&&f.then?f.then(d):d()})};if(!n.isAxiosError||!n.config)throw e.debug({msg:"FATAL: Received an non axios error in the rejected response interceptor, ignoring.",data:n}),n;var o=n.config,c=o.id,s=o.cache,u=n.response;if(!s||!c)throw e.debug({msg:"Web request returned an error but cache handling is not enabled",data:{error:n}}),n;var f=function(){if(!d(o.method,s.methods))return e.debug({id:c,msg:"Ignored because method ("+o.method+") is not in cache.methods ("+s.methods+")",data:{config:o,cacheConfig:s}}),Promise.resolve(r(c,o)).then(function(){throw n})}();return Promise.resolve(f&&f.then?f.then(i):i())}catch(e){return Promise.reject(e)}};return{onFulfilled:n,onRejected:i,apply:function(){return e.interceptors.response.use(n,i)}}}var x=function(e){return!!e&&!!e["is-storage"]};function j(e){var t=e.data.headers;return a.ETag in t||a.LastModified in t||a.XAxiosCacheEtag in t||a.XAxiosCacheLastModified in t}function A(e){return String(e.data.headers[a.CacheControl]).includes("must-revalidate")}function E(e){return!!j(e)||"cached"===e.state&&void 0!==e.staleTtl&&Math.abs(Date.now()-(e.createdAt+e.ttl))<=e.staleTtl}function T(e){return void 0!==e.ttl&&e.createdAt+e.ttl<=Date.now()}function O(e){var t=e.set,r=e.find,n=e.remove;return{"is-storage":1,set:t,remove:n,get:function(e,a){try{return Promise.resolve(r(e,a)).then(function(r){var i;function c(t){return i?t:T(r)?j(r)?r:Promise.resolve(n(e,a)).then(function(){return{state:"empty"}}):r}if(!r)return{state:"empty"};if("empty"===r.state||"loading"===r.state||"must-revalidate"===r.state)return r;var s=function(){if("cached"===r.state){var c=function(n){return i?n:(r={state:"stale",createdAt:r.createdAt,data:r.data,ttl:void 0!==r.staleTtl?r.staleTtl+r.ttl:void 0},Promise.resolve(t(e,r,a)).then(function(){if(A(r)){var e=o({},r,{state:"must-revalidate"});return i=1,e}}))};if(!T(r))return i=1,r;var s=function(){if(!E(r))return Promise.resolve(n(e,a)).then(function(){return i=1,{state:"empty"}})}();return s&&s.then?s.then(c):c(s)}}();return s&&s.then?s.then(c):c(s)})}catch(e){return Promise.reject(e)}}}}function R(e,t,r){void 0===e&&(e=!1),void 0===t&&(t=!1),void 0===r&&(r=!1);var n=O({set:function(t,a){if(r){var i=Object.keys(n.data);if(i.length>=r)for(n.cleanup(),i=Object.keys(n.data);i.length>=r;)delete n.data[i.shift()]}n.data[t]="double"===e?"function"==typeof structuredClone?structuredClone(a):JSON.parse(JSON.stringify(a)):a},remove:function(e){delete n.data[e]},find:function(t){var r=n.data[t];return e&&void 0!==r?"function"==typeof structuredClone?structuredClone(r):JSON.parse(JSON.stringify(r)):r}});return n.data=Object.create(null),n.cleanup=function(){for(var e,t,r=Object.keys(n.data),a=-1;++a<r.length;)"empty"!==(e=n.data[t=r[a]]).state?"cached"===e.state&&T(e)&&!E(e)&&n.remove(t):n.remove(t)},t&&(n.cleaner=setInterval(n.cleanup,t)),n}var M=/^\/|\/$/g;function q(e){return function(t){if(t.id)return t.id;var r=e(t);return"string"==typeof r||"number"==typeof r?""+r:""+n.hash(r)}}var k=q(function(e){var t=e.baseURL,r=e.url,n=e.method,a=e.params,i=e.data;return t=void 0!==t?t.replace(M,""):"",r=void 0!==r?r.replace(M,""):"",{url:t+(t&&r?"/":"")+r,params:a,method:n=void 0!==n?n.toLowerCase():"get",data:i}});console.error("You are using a development build. Make sure to use the correct build in production\nhttps://axios-cache-interceptor.js.org/guide/getting-started\n\n"),e.Header=a,e.buildKeyGenerator=q,e.buildMemoryStorage=R,e.buildStorage=O,e.buildWebStorage=function(e,t){return void 0===t&&(t="axios-cache-"),O({find:function(r){var n=e.getItem(t+r);return n?JSON.parse(n):void 0},remove:function(r){e.removeItem(t+r)},set:function(r,n){var a=function(){return e.setItem(t+r,JSON.stringify(n))};try{return a()}catch(n){for(var i,o=Object.entries(e).filter(function(e){return e[0].startsWith(t)}).map(function(e){return[e[0],JSON.parse(e[1])]}),c=s(o);!(i=c()).done;){var u=i.value;"cached"===u[1].state&&T(u[1])&&!E(u[1])&&e.removeItem(u[0])}try{return a()}catch(t){for(var d,f=s(o.sort(function(e,t){return(e[1].createdAt||0)-(t[1].createdAt||0)}));!(d=f()).done;){e.removeItem(d.value[0]);try{return a()}catch(e){}}}e.removeItem(t+r)}}})},e.canStale=E,e.createCacheResponse=h,e.createValidateStatus=u,e.defaultHeaderInterpreter=i,e.defaultKeyGenerator=k,e.defaultRequestInterceptor=l,e.defaultResponseInterceptor=C,e.isExpired=T,e.isMethodIn=d,e.isStorage=x,e.mustRevalidate=A,e.setupCache=function(e,t){var r,n,a,o,c,s,u,d;void 0===t&&(t={});var f=e;if(f.defaults.cache)throw new Error("setupCache() should be called only once");if(f.storage=t.storage||R(),!x(f.storage))throw new Error("Use buildStorage() function");return f.waiting=t.waiting||{},f.generateKey=t.generateKey||k,f.headerInterpreter=t.headerInterpreter||i,f.requestInterceptor=t.requestInterceptor||l(f),f.responseInterceptor=t.responseInterceptor||C(f),f.debug=t.debug||function(){},f.defaults.cache={update:t.update||{},ttl:null!=(r=t.ttl)?r:3e5,methods:t.methods||["get","head"],cachePredicate:t.cachePredicate||{statusCheck:function(e){return[200,203,300,301,302,404,405,410,414,501].includes(e)}},etag:null==(n=t.etag)||n,modifiedSince:null!=(a=t.modifiedSince)?a:!1===t.etag,interpretHeader:null==(o=t.interpretHeader)||o,cacheTakeover:null==(c=t.cacheTakeover)||c,staleIfError:null==(s=t.staleIfError)||s,override:null!=(u=t.override)&&u,hydrate:null!=(d=t.hydrate)?d:void 0},f.requestInterceptor.apply(),f.responseInterceptor.apply(),f},e.testCachePredicate=b,e.updateCache=I,e.updateStaleRequest=f});
//# sourceMappingURL=index.bundle.js.map