/*!
 * Axios Cache Interceptor 1.5.2
 * (c) 2021-present Arthur Fiorette & Contributors
 * Released under the MIT License.
 */
/**
 * Creates a simple storage. You can persist his data by using `sessionStorage` or
 * `localStorage` with it.
 *
 * **ImplNote**: Without polyfill, this storage only works on browser environments.
 *
 * @example
 *
 * ```js
 * const fromLocalStorage = buildWebStorage(localStorage);
 * const fromSessionStorage = buildWebStorage(sessionStorage);
 *
 * const myStorage = new Storage();
 * const fromMyStorage = buildWebStorage(myStorage);
 * ```
 *
 * @param storage The type of web storage to use. localStorage or sessionStorage.
 * @param prefix The prefix to index the storage. Useful to prevent collision between
 *   multiple places using the same storage.
 */
export declare function buildWebStorage(storage: Storage, prefix?: string): import("./types.mjs").AxiosStorage;
//# sourceMappingURL=web-api.d.ts.map