"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _intn = _interopRequireDefault(require("./intn"));
var _writableTrackingBuffer = _interopRequireDefault(require("../tracking-buffer/writable-tracking-buffer"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
const DATA_LENGTH = Buffer.from([0x08]);
const NULL_LENGTH = Buffer.from([0x00]);
const MAX_SAFE_BIGINT = 9223372036854775807n;
const MIN_SAFE_BIGINT = -9223372036854775808n;
const BigInt = {
  id: 0x7F,
  type: 'INT8',
  name: 'BigInt',
  declaration: function () {
    return 'bigint';
  },
  generateTypeInfo() {
    return Buffer.from([_intn.default.id, 0x08]);
  },
  generateParameterLength(parameter, options) {
    if (parameter.value == null) {
      return NULL_LENGTH;
    }
    return DATA_LENGTH;
  },
  *generateParameterData(parameter, options) {
    if (parameter.value == null) {
      return;
    }
    const buffer = new _writableTrackingBuffer.default(8);
    buffer.writeInt64LE(Number(parameter.value));
    yield buffer.data;
  },
  validate: function (value) {
    if (value == null) {
      return null;
    }
    if (typeof value !== 'bigint') {
      value = globalThis.BigInt(value);
    }
    if (value < MIN_SAFE_BIGINT || value > MAX_SAFE_BIGINT) {
      throw new TypeError(`Value must be between ${MIN_SAFE_BIGINT} and ${MAX_SAFE_BIGINT}, inclusive.`);
    }
    return value;
  }
};
var _default = exports.default = BigInt;
module.exports = BigInt;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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