"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _events = require("events");
var util = _interopRequireWildcard(require("util"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Debug extends _events.EventEmitter {
  /*
    @options    Which debug details should be sent.
                data    - dump of packet data
                payload - details of decoded payload
  */
  constructor({
    data = false,
    payload = false,
    packet = false,
    token = false
  } = {}) {
    super();
    this.options = {
      data,
      payload,
      packet,
      token
    };
    this.indent = '  ';
  }
  packet(direction, packet) {
    if (this.haveListeners() && this.options.packet) {
      this.log('');
      this.log(direction);
      this.log(packet.headerToString(this.indent));
    }
  }
  data(packet) {
    if (this.haveListeners() && this.options.data) {
      this.log(packet.dataToString(this.indent));
    }
  }
  payload(generatePayloadText) {
    if (this.haveListeners() && this.options.payload) {
      this.log(generatePayloadText());
    }
  }
  token(token) {
    if (this.haveListeners() && this.options.token) {
      this.log(util.inspect(token, {
        showHidden: false,
        depth: 5,
        colors: true
      }));
    }
  }
  haveListeners() {
    return this.listeners('debug').length > 0;
  }
  log(text) {
    this.emit('debug', text);
  }
}
var _default = exports.default = Debug;
module.exports = Debug;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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