import cors from 'cors';
export default {
  id: 'api',
  handler: (router, context) => {
    const { services, database, getSchema, env, logger, emitter } = context
    const { ItemsService, UsersService, AuthenticationService } = services
  const allowedOrigins = [
      'http://localhost:3000', 
      'https://victronenergy.vercel.app'
    ];

    const corsOptions = {
      origin: (origin, callback) => {
        if (!origin || allowedOrigins.includes(origin)) {
          callback(null, true); 
        } else {
          callback(new Error('Not allowed by CORS')); 
        }
      },
      methods: ['GET', 'POST'],
      allowedHeaders: ['Content-Type', 'Authorization'],
      credentials: true,
    };

 
    router.use(cors(corsOptions));
    router.get('/syncronize', async (req, res) => {
      try {
        const installationsService = new ItemsService('installations', {
          schema: await getSchema()
        })

        const extendedDataService = new ItemsService('extended_data', {
          schema: await getSchema()
        })

        const options = {
          method: 'GET',
          headers: {
            accept: 'application/json',
            'content-type': 'application/json',
            'x-authorization':
              'Token 50b2ae9bb86d45c62c2ec58532c301044db9557c2751d73759b92209b4f5182d'
          }
        }

        const response = await fetch(
          'https://vrmapi.victronenergy.com/v2/users/252912/installations?extended=1',
          options
        )
        const data = await response.json()
        let created_installations = 0
        let created_extended = 0
        const required_attributes = [330, 331, 917]

        for (var i = 0; i < data['records'].length; i++) {
          let obj = data['records'][i]
          let installation
          let installations = await installationsService.readByQuery({
            filter: {
              idSite: {
                _eq: obj['idSite']
              }
            }
          })
          if (installations.length > 0) {
            installation = installations[0]
          } else {
            installation = await installationsService.createOne({
              idSite: obj.idSite,
              name: obj.name,
              identifier: obj.identifier,
              has_mains: obj.hasMains,
              has_generator: obj.hasGenerator,
              last_timestamp: new Date(obj.last_timestamp * 1000)
            })
            created_installations += 1
          }
          for (var j = 0; j < obj['extended'].length; j++) {
            let extended = obj['extended'][j]
            if (
              required_attributes.includes(extended.idDataAttribute) == false
            ) {
              continue
            }
            let extended_data = await extendedDataService.readByQuery({
              filter: {
                idDataAttribute: {
                  _eq: extended.idDataAttribute
                },
                timestamp_as: extended.timestamp
              }
            })
            if (extended_data.length == 0) {
              await extendedDataService.createOne({
                installation: installation.id,
                idDataAttribute: extended['idDataAttribute'],
                code: extended['code'],
                description: extended['description'],
                formatWithUnit: extended['formatWithUnit'],
                rawValueNumber: extended['rawValue'],
                formattedValue: extended['formattedValue'],
                formattedValue: extended['formattedValue'],
                timestamp_as: extended['timestamp'],
                timestamp: new Date(extended['timestamp'] * 1000)
              })
              created_extended += 1
            }
          }
        }
        res.json({
          success: true,
          created_installations: created_installations,
          created_extended: created_extended,
        })
      } catch (error) {
        res.status(500).json({
          success: false,
          error: error.message
        })
      }
    })
  }
}
