import type { Item, Query } from '@directus/types';
import { z } from 'zod';
export declare const WebSocketMessage: z.ZodObject<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, z.ZodTypeAny, "passthrough">>;
export type WebSocketMessage = z.infer<typeof WebSocketMessage>;
export declare const WebSocketResponse: z.ZodDiscriminatedUnion<"status", [z.ZodObject<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    status: z.ZodLiteral<"ok">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    status: z.ZodLiteral<"ok">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    status: z.ZodLiteral<"ok">;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    status: z.ZodLiteral<"error">;
    error: z.ZodObject<{
        code: z.ZodString;
        message: z.ZodString;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        code: z.ZodString;
        message: z.ZodString;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        code: z.ZodString;
        message: z.ZodString;
    }, z.ZodTypeAny, "passthrough">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    status: z.ZodLiteral<"error">;
    error: z.ZodObject<{
        code: z.ZodString;
        message: z.ZodString;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        code: z.ZodString;
        message: z.ZodString;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        code: z.ZodString;
        message: z.ZodString;
    }, z.ZodTypeAny, "passthrough">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    status: z.ZodLiteral<"error">;
    error: z.ZodObject<{
        code: z.ZodString;
        message: z.ZodString;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        code: z.ZodString;
        message: z.ZodString;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        code: z.ZodString;
        message: z.ZodString;
    }, z.ZodTypeAny, "passthrough">>;
}>, z.ZodTypeAny, "passthrough">>]>;
export type WebSocketResponse = z.infer<typeof WebSocketResponse>;
export declare const ConnectionParams: z.ZodObject<{
    access_token: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    access_token?: string | undefined;
}, {
    access_token?: string | undefined;
}>;
export type ConnectionParams = z.infer<typeof ConnectionParams>;
export declare const BasicAuthMessage: z.ZodUnion<[z.ZodObject<{
    email: z.ZodString;
    password: z.ZodString;
}, "strip", z.ZodTypeAny, {
    email: string;
    password: string;
}, {
    email: string;
    password: string;
}>, z.ZodObject<{
    access_token: z.ZodString;
}, "strip", z.ZodTypeAny, {
    access_token: string;
}, {
    access_token: string;
}>, z.ZodObject<{
    refresh_token: z.ZodString;
}, "strip", z.ZodTypeAny, {
    refresh_token: string;
}, {
    refresh_token: string;
}>]>;
export type BasicAuthMessage = z.infer<typeof BasicAuthMessage>;
export declare const WebSocketAuthMessage: z.ZodIntersection<z.ZodObject<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"auth">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"auth">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"auth">;
}>, z.ZodTypeAny, "passthrough">>, z.ZodUnion<[z.ZodObject<{
    email: z.ZodString;
    password: z.ZodString;
}, "strip", z.ZodTypeAny, {
    email: string;
    password: string;
}, {
    email: string;
    password: string;
}>, z.ZodObject<{
    access_token: z.ZodString;
}, "strip", z.ZodTypeAny, {
    access_token: string;
}, {
    access_token: string;
}>, z.ZodObject<{
    refresh_token: z.ZodString;
}, "strip", z.ZodTypeAny, {
    refresh_token: string;
}, {
    refresh_token: string;
}>]>>;
export type WebSocketAuthMessage = z.infer<typeof WebSocketAuthMessage>;
export declare const WebSocketSubscribeMessage: z.ZodDiscriminatedUnion<"type", [z.ZodObject<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"subscribe">;
    collection: z.ZodString;
    event: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"create">, z.ZodLiteral<"update">, z.ZodLiteral<"delete">]>>;
    item: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"subscribe">;
    collection: z.ZodString;
    event: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"create">, z.ZodLiteral<"update">, z.ZodLiteral<"delete">]>>;
    item: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"subscribe">;
    collection: z.ZodString;
    event: z.ZodOptional<z.ZodUnion<[z.ZodLiteral<"create">, z.ZodLiteral<"update">, z.ZodLiteral<"delete">]>>;
    item: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"unsubscribe">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"unsubscribe">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    type: z.ZodString;
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, {
    type: z.ZodLiteral<"unsubscribe">;
}>, z.ZodTypeAny, "passthrough">>]>;
export type WebSocketSubscribeMessage = z.infer<typeof WebSocketSubscribeMessage>;
export declare const WebSocketItemsMessage: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    type: z.ZodLiteral<"items">;
    collection: z.ZodString;
}, {
    action: z.ZodLiteral<"create">;
    data: z.ZodUnion<[z.ZodArray<z.ZodType<Partial<Item>, z.ZodTypeDef, Partial<Item>>, "many">, z.ZodType<Partial<Item>, z.ZodTypeDef, Partial<Item>>]>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, "strip", z.ZodTypeAny, {
    collection: string;
    type: "items";
    action: "create";
    data: Partial<Item> | Partial<Item>[];
    query?: Query | undefined;
    uid?: string | number | undefined;
}, {
    collection: string;
    type: "items";
    action: "create";
    data: Partial<Item> | Partial<Item>[];
    query?: Query | undefined;
    uid?: string | number | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    type: z.ZodLiteral<"items">;
    collection: z.ZodString;
}, {
    action: z.ZodLiteral<"read">;
    ids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">>;
    id: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, "strip", z.ZodTypeAny, {
    collection: string;
    type: "items";
    action: "read";
    query?: Query | undefined;
    id?: string | number | undefined;
    uid?: string | number | undefined;
    ids?: (string | number)[] | undefined;
}, {
    collection: string;
    type: "items";
    action: "read";
    query?: Query | undefined;
    id?: string | number | undefined;
    uid?: string | number | undefined;
    ids?: (string | number)[] | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    type: z.ZodLiteral<"items">;
    collection: z.ZodString;
}, {
    action: z.ZodLiteral<"update">;
    data: z.ZodType<Partial<Item>, z.ZodTypeDef, Partial<Item>>;
    ids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">>;
    id: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, "strip", z.ZodTypeAny, {
    collection: string;
    type: "items";
    action: "update";
    data: Partial<Item>;
    query?: Query | undefined;
    id?: string | number | undefined;
    uid?: string | number | undefined;
    ids?: (string | number)[] | undefined;
}, {
    collection: string;
    type: "items";
    action: "update";
    data: Partial<Item>;
    query?: Query | undefined;
    id?: string | number | undefined;
    uid?: string | number | undefined;
    ids?: (string | number)[] | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    uid: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    type: z.ZodLiteral<"items">;
    collection: z.ZodString;
}, {
    action: z.ZodLiteral<"delete">;
    ids: z.ZodOptional<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">>;
    id: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    query: z.ZodOptional<z.ZodType<Query, z.ZodTypeDef, Query>>;
}>, "strip", z.ZodTypeAny, {
    collection: string;
    type: "items";
    action: "delete";
    query?: Query | undefined;
    id?: string | number | undefined;
    uid?: string | number | undefined;
    ids?: (string | number)[] | undefined;
}, {
    collection: string;
    type: "items";
    action: "delete";
    query?: Query | undefined;
    id?: string | number | undefined;
    uid?: string | number | undefined;
    ids?: (string | number)[] | undefined;
}>]>;
export type WebSocketItemsMessage = z.infer<typeof WebSocketItemsMessage>;
export declare const WebSocketEvent: z.ZodDiscriminatedUnion<"action", [z.ZodObject<{
    action: z.ZodLiteral<"create">;
    collection: z.ZodString;
    payload: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    key: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
}, "strip", z.ZodTypeAny, {
    collection: string;
    key: string | number;
    action: "create";
    payload?: Record<string, any> | undefined;
}, {
    collection: string;
    key: string | number;
    action: "create";
    payload?: Record<string, any> | undefined;
}>, z.ZodObject<{
    action: z.ZodLiteral<"update">;
    collection: z.ZodString;
    payload: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    keys: z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">;
}, "strip", z.ZodTypeAny, {
    collection: string;
    action: "update";
    keys: (string | number)[];
    payload?: Record<string, any> | undefined;
}, {
    collection: string;
    action: "update";
    keys: (string | number)[];
    payload?: Record<string, any> | undefined;
}>, z.ZodObject<{
    action: z.ZodLiteral<"delete">;
    collection: z.ZodString;
    payload: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodAny>>;
    keys: z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodNumber]>, "many">;
}, "strip", z.ZodTypeAny, {
    collection: string;
    action: "delete";
    keys: (string | number)[];
    payload?: Record<string, any> | undefined;
}, {
    collection: string;
    action: "delete";
    keys: (string | number)[];
    payload?: Record<string, any> | undefined;
}>]>;
export type WebSocketEvent = z.infer<typeof WebSocketEvent>;
export declare const AuthMode: z.ZodUnion<[z.ZodLiteral<"public">, z.ZodLiteral<"handshake">, z.ZodLiteral<"strict">]>;
export type AuthMode = z.infer<typeof AuthMode>;
