'use strict';

const unhead = require('unhead');
const injectHead = require('./shared/vue.fe30115b.cjs');
const vue = require('vue');
const useHead = require('./shared/vue.8753d82d.cjs');
const shared = require('@unhead/shared');

const VueHeadMixin = {
  created() {
    let source = false;
    if (injectHead.Vue3) {
      const instance = vue.getCurrentInstance();
      if (!instance)
        return;
      const options = instance.type;
      if (!options || !("head" in options))
        return;
      source = typeof options.head === "function" ? () => options.head.call(instance.proxy) : options.head;
    } else {
      const head = this.$options.head;
      if (head) {
        source = typeof head === "function" ? () => head.call(this) : head;
      }
    }
    source && useHead.useHead(source);
  }
};

const Vue2ProvideUnheadPlugin = (_Vue, head) => {
  _Vue.mixin({
    beforeCreate() {
      const options = this.$options;
      const origProvide = options.provide;
      options.provide = function() {
        let origProvideResult;
        if (typeof origProvide === "function")
          origProvideResult = origProvide.call(this);
        else
          origProvideResult = origProvide || {};
        return {
          ...origProvideResult,
          [injectHead.headSymbol]: head
        };
      };
    }
  });
};

const coreComposableNames = [
  "injectHead"
];
const unheadVueComposablesImports = {
  "@unhead/vue": [...coreComposableNames, ...shared.composableNames]
};

function useHeadSafe(input, options = {}) {
  return useHead.useHead(input, { ...options, transform: shared.whitelistSafeInput });
}

function useSeoMeta(input, options) {
  const { title, titleTemplate, ...meta } = input;
  return useHead.useHead({
    title,
    titleTemplate,
    // @ts-expect-error runtime type
    _flatMeta: meta
  }, {
    ...options,
    transform(t) {
      const meta2 = shared.unpackMeta({ ...t._flatMeta });
      delete t._flatMeta;
      return {
        // @ts-expect-error runtime type
        ...t,
        meta: meta2
      };
    }
  });
}

function useServerHead(input, options = {}) {
  const head = options.head || injectHead.injectHead();
  delete options.head;
  if (head)
    return head.push(input, { ...options, mode: "server" });
}

function useServerHeadSafe(input, options = {}) {
  return useHeadSafe(input, { ...options, mode: "server" });
}

function useServerSeoMeta(input, options) {
  return useSeoMeta(input, { ...options, mode: "server" });
}

function useScript(_input, _options) {
  const input = typeof _input === "string" ? { src: _input } : _input;
  const head = injectHead.injectHead();
  const options = _options || {};
  options.head = head;
  options.eventContext = vue.getCurrentInstance();
  const scope = vue.getCurrentInstance();
  if (scope && !options.trigger)
    options.trigger = vue.onMounted;
  const key = unhead.resolveScriptKey(input);
  if (head._scripts?.[key])
    return head._scripts[key];
  let script;
  const status = vue.ref("awaitingLoad");
  const _ = head.hooks.hook("script:updated", ({ script: s }) => {
    if (script && s.id === script.id) {
      status.value = s.status;
      if (s.status === "removed") {
        _();
      }
    }
  });
  script = unhead.useScript(input, options);
  if (scope) {
    const _registerCb = (key2, cb) => {
      if (!script._cbs[key2]) {
        cb(script.instance);
        return () => {
        };
      }
      let i = script._cbs[key2].push(cb);
      const destroy = () => {
        if (i) {
          script._cbs[key2]?.splice(i - 1, 1);
          i = null;
        }
      };
      vue.onScopeDispose(destroy);
      return destroy;
    };
    script.onLoaded = (cb) => _registerCb("loaded", cb);
    script.onError = (cb) => _registerCb("error", cb);
  }
  return new Proxy(script, {
    get(_2, key2, a) {
      if (key2 === "status")
        return status;
      return Reflect.get(_2, key2, a);
    }
  });
}

exports.CapoPlugin = unhead.CapoPlugin;
exports.HashHydrationPlugin = unhead.HashHydrationPlugin;
exports.createHeadCore = unhead.createHeadCore;
exports.createHead = injectHead.createHead;
exports.createServerHead = injectHead.createServerHead;
exports.injectHead = injectHead.injectHead;
exports.resolveUnrefHeadInput = injectHead.resolveUnrefHeadInput;
exports.setHeadInjectionHandler = injectHead.setHeadInjectionHandler;
exports.useHead = useHead.useHead;
exports.Vue2ProvideUnheadPlugin = Vue2ProvideUnheadPlugin;
exports.VueHeadMixin = VueHeadMixin;
exports.unheadVueComposablesImports = unheadVueComposablesImports;
exports.useHeadSafe = useHeadSafe;
exports.useScript = useScript;
exports.useSeoMeta = useSeoMeta;
exports.useServerHead = useServerHead;
exports.useServerHeadSafe = useServerHeadSafe;
exports.useServerSeoMeta = useServerSeoMeta;
