import { GraphQLInterfaceType, GraphQLObjectType } from './graphql';
import { ObjectTypeComposer } from './ObjectTypeComposer';
import type { GraphQLFieldConfig, GraphQLOutputType, GraphQLInputObjectType, GraphQLInputType, GraphQLResolveInfo, GraphQLTypeResolver } from './graphql';
import { InputTypeComposer } from './InputTypeComposer';
import type { TypeAsString, TypeDefinitionString } from './TypeMapper';
import { SchemaComposer } from './SchemaComposer';
import type { ObjectTypeComposerFieldConfigMap, ObjectTypeComposerFieldConfig, ObjectTypeComposerFieldConfigDefinition, ObjectTypeComposerFieldConfigAsObjectDefinition, ObjectTypeComposerFieldConfigMapDefinition, ObjectTypeComposerArgumentConfigMapDefinition, ObjectTypeComposerArgumentConfig, ObjectTypeComposerArgumentConfigDefinition, ObjectTypeComposerArgumentConfigMap } from './ObjectTypeComposer';
import { ListComposer } from './ListComposer';
import { NonNullComposer } from './NonNullComposer';
import { ThunkComposer } from './ThunkComposer';
import type { Extensions, MaybePromise, DirectiveArgs, Directive, ThunkWithSchemaComposer } from './utils/definitions';
import type { ToInputTypeOpts } from './utils/toInputType';
import { TypeInPath } from './utils/typeByPath';
import { NamedTypeComposer } from './utils/typeHelpers';
import type { ComposeNamedInputType, ComposeNamedOutputType } from './utils/typeHelpers';
import { SchemaPrinterOptions } from './utils/schemaPrinter';
export declare type InterfaceTypeComposerDefinition<TSource, TContext> = TypeAsString | TypeDefinitionString | InterfaceTypeComposerAsObjectDefinition<TSource, TContext> | GraphQLInterfaceType | Readonly<InterfaceTypeComposerThunked<any, TContext>>;
export declare type InterfaceTypeComposerAsObjectDefinition<TSource, TContext> = {
    name: string;
    fields?: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>;
    interfaces?: null | ThunkWithSchemaComposer<ReadonlyArray<InterfaceTypeComposerDefinition<any, TContext>>, SchemaComposer<TContext>>;
    resolveType?: null | GraphQLTypeResolver<TSource, TContext>;
    description?: null | string;
    extensions?: Extensions;
    directives?: Directive[];
};
export declare type InterfaceTypeComposerResolversMap<TContext> = Map<ObjectTypeComposer<any, TContext> | GraphQLObjectType, InterfaceTypeComposerResolverCheckFn<any, TContext>>;
export declare type InterfaceTypeComposerResolverCheckFn<TSource, TContext> = (value: TSource, context: TContext, info: GraphQLResolveInfo) => MaybePromise<boolean | null | void>;
export declare type InterfaceTypeComposerThunked<TReturn, TContext> = InterfaceTypeComposer<TReturn, TContext> | ThunkComposer<InterfaceTypeComposer<any, any>, GraphQLInterfaceType>;
export declare class InterfaceTypeComposer<TSource = any, TContext = any> {
    schemaComposer: SchemaComposer<TContext>;
    _gqType: GraphQLInterfaceType;
    _gqcFields: ObjectTypeComposerFieldConfigMap<TSource, TContext>;
    _gqcInputTypeComposer: undefined | InputTypeComposer<TContext>;
    _gqcInterfaces: Array<InterfaceTypeComposerThunked<TSource, TContext>>;
    _gqcTypeResolvers: undefined | InterfaceTypeComposerResolversMap<TContext>;
    _gqcFallbackResolveType: ObjectTypeComposer<any, TContext> | GraphQLObjectType | null;
    _gqcExtensions?: Extensions;
    _gqcDirectives?: Directive[];
    _gqcIsModified?: boolean;
    static create<TSrc = any, TCtx = any>(typeDef: InterfaceTypeComposerDefinition<TSrc, TCtx>, schemaComposer: SchemaComposer<TCtx>): InterfaceTypeComposer<TSrc, TCtx>;
    static createTemp<TSrc = any, TCtx = any>(typeDef: InterfaceTypeComposerDefinition<TSrc, TCtx>, schemaComposer?: SchemaComposer<TCtx>): InterfaceTypeComposer<TSrc, TCtx>;
    constructor(graphqlType: GraphQLInterfaceType, schemaComposer: SchemaComposer<TContext>);
    getFields(): ObjectTypeComposerFieldConfigMap<TSource, TContext>;
    getFieldNames(): string[];
    getField(fieldName: string): ObjectTypeComposerFieldConfig<TSource, TContext>;
    hasField(fieldName: string): boolean;
    setFields(fields: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>): this;
    setField(fieldName: string, fieldConfig: ObjectTypeComposerFieldConfigDefinition<TSource, TContext>): this;
    addFields(newFields: ObjectTypeComposerFieldConfigMapDefinition<TSource, TContext>): this;
    removeField(fieldNameOrArray: string | string[]): this;
    removeOtherFields(fieldNameOrArray: string | string[]): this;
    reorderFields(names: string[]): this;
    extendField(fieldName: string, partialFieldConfig: Partial<ObjectTypeComposerFieldConfigAsObjectDefinition<TSource, TContext>>): this;
    getFieldConfig(fieldName: string): GraphQLFieldConfig<TSource, TContext>;
    getFieldType(fieldName: string): GraphQLOutputType;
    getFieldTypeName(fieldName: string): string;
    getFieldTC(fieldName: string): ComposeNamedOutputType<TContext>;
    getFieldOTC(fieldName: string): ObjectTypeComposer<TSource, TContext>;
    isFieldNonNull(fieldName: string): boolean;
    makeFieldNonNull(fieldNameOrArray: string | string[]): this;
    makeFieldNullable(fieldNameOrArray: string | string[]): this;
    isFieldPlural(fieldName: string): boolean;
    makeFieldPlural(fieldNameOrArray: string | string[]): this;
    makeFieldNonPlural(fieldNameOrArray: string | string[]): this;
    deprecateFields(fields: {
        [fieldName: string]: string;
    } | string[] | string): this;
    getFieldArgs<TArgs = any>(fieldName: string): ObjectTypeComposerArgumentConfigMap<TArgs>;
    getFieldArgNames(fieldName: string): string[];
    hasFieldArg(fieldName: string, argName: string): boolean;
    getFieldArg(fieldName: string, argName: string): ObjectTypeComposerArgumentConfig;
    getFieldArgType(fieldName: string, argName: string): GraphQLInputType;
    getFieldArgTypeName(fieldName: string, argName: string): string;
    getFieldArgTC(fieldName: string, argName: string): ComposeNamedInputType<TContext>;
    getFieldArgITC(fieldName: string, argName: string): InputTypeComposer<TContext>;
    setFieldArgs(fieldName: string, args: ObjectTypeComposerArgumentConfigMapDefinition<any>): this;
    addFieldArgs(fieldName: string, newArgs: ObjectTypeComposerArgumentConfigMapDefinition<any>): this;
    setFieldArg(fieldName: string, argName: string, argConfig: ObjectTypeComposerArgumentConfigDefinition): this;
    isFieldArgPlural(fieldName: string, argName: string): boolean;
    makeFieldArgPlural(fieldName: string, argNameOrArray: string | string[]): this;
    makeFieldArgNonPlural(fieldName: string, argNameOrArray: string | string[]): this;
    isFieldArgNonNull(fieldName: string, argName: string): boolean;
    makeFieldArgNonNull(fieldName: string, argNameOrArray: string | string[]): this;
    makeFieldArgNullable(fieldName: string, argNameOrArray: string | string[]): this;
    getType(): GraphQLInterfaceType;
    getTypePlural(): ListComposer<InterfaceTypeComposer<TSource, TContext>>;
    getTypeNonNull(): NonNullComposer<InterfaceTypeComposer<TSource, TContext>>;
    get List(): ListComposer<InterfaceTypeComposer<TSource, TContext>>;
    get NonNull(): NonNullComposer<InterfaceTypeComposer<TSource, TContext>>;
    getTypeName(): string;
    setTypeName(name: string): this;
    getDescription(): string;
    setDescription(description: string): this;
    clone(newTypeNameOrTC: string | InterfaceTypeComposer<any, any>): InterfaceTypeComposer<TSource, TContext>;
    cloneTo(anotherSchemaComposer: SchemaComposer<any>, cloneMap?: Map<any, any>): InterfaceTypeComposer<any, any>;
    merge(type: GraphQLInterfaceType | GraphQLObjectType | InterfaceTypeComposer<any, any> | ObjectTypeComposer<any, any>): this;
    getInputType(): GraphQLInputObjectType;
    hasInputTypeComposer(): boolean;
    setInputTypeComposer(itc: InputTypeComposer<TContext>): this;
    getInputTypeComposer(opts?: ToInputTypeOpts): InputTypeComposer<TContext>;
    getITC(opts?: ToInputTypeOpts): InputTypeComposer<TContext>;
    removeInputTypeComposer(): this;
    getResolveType(): GraphQLTypeResolver<TSource, TContext> | undefined | null;
    setResolveType(fn: GraphQLTypeResolver<TSource, TContext> | undefined | null): this;
    hasTypeResolver(type: ObjectTypeComposer<any, TContext> | GraphQLObjectType): boolean;
    getTypeResolvers(): InterfaceTypeComposerResolversMap<TContext>;
    getTypeResolverCheckFn(type: ObjectTypeComposer<any, TContext> | GraphQLObjectType): InterfaceTypeComposerResolverCheckFn<TSource, TContext>;
    getTypeResolverNames(): string[];
    getTypeResolverTypes(): GraphQLObjectType[];
    setTypeResolvers(typeResolversMap: InterfaceTypeComposerResolversMap<TContext>): this;
    _initResolveTypeFn(): this;
    _isTypeResolversValid(typeResolversMap: InterfaceTypeComposerResolversMap<TContext>): true;
    _isTypeResolverValid(composeType: ObjectTypeComposer<any, TContext> | GraphQLObjectType, checkFn: InterfaceTypeComposerResolverCheckFn<any, TContext>): true;
    _isTypeResolversAsync(typeResolversMap: InterfaceTypeComposerResolversMap<TContext>): boolean;
    addTypeResolver<TSrc>(type: ObjectTypeComposer<TSrc, TContext> | GraphQLObjectType, checkFn: InterfaceTypeComposerResolverCheckFn<TSrc, TContext>): this;
    removeTypeResolver(type: ObjectTypeComposer<any, TContext> | GraphQLObjectType): this;
    setTypeResolverFallback(type: ObjectTypeComposer<any, TContext> | GraphQLObjectType | null): this;
    getInterfaces(): Array<InterfaceTypeComposerThunked<TSource, TContext>>;
    getInterfacesTypes(): Array<GraphQLInterfaceType>;
    setInterfaces(interfaces: ReadonlyArray<InterfaceTypeComposerDefinition<any, TContext>>): this;
    hasInterface(iface: InterfaceTypeComposerDefinition<any, TContext>): boolean;
    addInterface(iface: InterfaceTypeComposerDefinition<any, TContext> | InterfaceTypeComposerThunked<any, TContext>): this;
    addInterfaces(ifaces: ReadonlyArray<InterfaceTypeComposerDefinition<any, TContext> | InterfaceTypeComposerThunked<any, TContext>>): this;
    removeInterface(iface: InterfaceTypeComposerDefinition<any, TContext>): this;
    getExtensions(): Extensions;
    setExtensions(extensions: Extensions | undefined): this;
    extendExtensions(extensions: Extensions): this;
    clearExtensions(): this;
    getExtension(extensionName: string): unknown;
    hasExtension(extensionName: string): boolean;
    setExtension(extensionName: string, value: unknown): this;
    removeExtension(extensionName: string): this;
    getFieldExtensions(fieldName: string): Extensions;
    setFieldExtensions(fieldName: string, extensions: Extensions): this;
    extendFieldExtensions(fieldName: string, extensions: Extensions): this;
    clearFieldExtensions(fieldName: string): this;
    getFieldExtension(fieldName: string, extensionName: string): unknown;
    hasFieldExtension(fieldName: string, extensionName: string): boolean;
    setFieldExtension(fieldName: string, extensionName: string, value: unknown): this;
    removeFieldExtension(fieldName: string, extensionName: string): this;
    getFieldArgExtensions(fieldName: string, argName: string): Extensions;
    setFieldArgExtensions(fieldName: string, argName: string, extensions: Extensions): this;
    extendFieldArgExtensions(fieldName: string, argName: string, extensions: Extensions): this;
    clearFieldArgExtensions(fieldName: string, argName: string): this;
    getFieldArgExtension(fieldName: string, argName: string, extensionName: string): unknown;
    hasFieldArgExtension(fieldName: string, argName: string, extensionName: string): boolean;
    setFieldArgExtension(fieldName: string, argName: string, extensionName: string, value: unknown): this;
    removeFieldArgExtension(fieldName: string, argName: string, extensionName: string): this;
    getDirectives(): Array<Directive>;
    setDirectives(directives: Array<Directive>): this;
    getDirectiveNames(): string[];
    getDirectiveByName(directiveName: string): DirectiveArgs | undefined;
    setDirectiveByName(directiveName: string, args?: DirectiveArgs): this;
    getDirectiveById(idx: number): DirectiveArgs | undefined;
    getFieldDirectives(fieldName: string): Array<Directive>;
    setFieldDirectives(fieldName: string, directives: Array<Directive> | undefined): this;
    getFieldDirectiveNames(fieldName: string): string[];
    getFieldDirectiveByName(fieldName: string, directiveName: string): DirectiveArgs | undefined;
    setFieldDirectiveByName(fieldName: string, directiveName: string, args?: DirectiveArgs): this;
    getFieldDirectiveById(fieldName: string, idx: number): DirectiveArgs | undefined;
    getFieldArgDirectives(fieldName: string, argName: string): Array<Directive>;
    setFieldArgDirectives(fieldName: string, argName: string, directives: Array<Directive>): this;
    getFieldArgDirectiveNames(fieldName: string, argName: string): string[];
    getFieldArgDirectiveByName(fieldName: string, argName: string, directiveName: string): DirectiveArgs | undefined;
    setFieldArgDirectiveByName(fieldName: string, argName: string, directiveName: string, args?: DirectiveArgs): this;
    getFieldArgDirectiveById(fieldName: string, argName: string, idx: number): DirectiveArgs | undefined;
    get(path: string | string[]): TypeInPath<TContext> | void;
    getNestedTCs(opts?: {
        exclude?: string[];
    }, passedTypes?: Set<NamedTypeComposer<any>>): Set<NamedTypeComposer<any>>;
    toSDL(opts?: SchemaPrinterOptions & {
        deep?: boolean;
        exclude?: string[];
    }): string;
}
//# sourceMappingURL=InterfaceTypeComposer.d.ts.map