import * as zod from 'zod';

interface ErrorOptions {
    cause?: unknown;
}
declare class ValidationError extends Error {
    name: 'ZodValidationError';
    details: Array<zod.ZodIssue>;
    constructor(message?: string, options?: ErrorOptions);
    toString(): string;
}

declare function isValidationError(err: unknown): err is ValidationError;

declare function isValidationErrorLike(err: unknown): err is ValidationError;

declare function isZodErrorLike(err: unknown): err is zod.ZodError;

declare const errorMap: zod.ZodErrorMap;

type ZodIssue = zod.ZodIssue;
type FromZodIssueOptions = {
    issueSeparator?: string;
    unionSeparator?: string;
    prefix?: string | null;
    prefixSeparator?: string;
    includePath?: boolean;
};
declare function fromZodIssue(issue: ZodIssue, options?: FromZodIssueOptions): ValidationError;

type ZodError = zod.ZodError;
type FromZodErrorOptions = FromZodIssueOptions & {
    maxIssuesInMessage?: number;
};
declare function fromZodError(zodError: ZodError, options?: FromZodErrorOptions): ValidationError;

declare function fromError(err: unknown, options?: FromZodErrorOptions): ValidationError;

declare const toValidationError: (options?: Parameters<typeof fromZodError>[1]) => (err: unknown) => ValidationError;

export { type ErrorOptions, type FromZodErrorOptions, type FromZodIssueOptions, ValidationError, type ZodError, type ZodIssue, errorMap, fromError, fromZodError, fromZodIssue, isValidationError, isValidationErrorLike, isZodErrorLike, toValidationError };
