<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\Slider;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Image;
use File;
use Carbon\Carbon;
use Illuminate\Support\Facades\Validator;

class Extras extends Controller
{


    // Promotion Banner
    public function index()
    {
        $action=DB::table('btn_action')->where('cat','btn')->get();
        $data = DB::table('home_banner')->orderBy('id', 'DESC')->paginate();
        return view('pages/banner',['data'=>$data,'action'=>$action]);
    }

    public function storeBanner(Request $request)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $validate = Validator::make($request->all(), [
            'icon' => "required|mimes:jpeg,png,jpg",
        ],[
            'icon'=>'Please Select valid Image Supported Jpeg/Png'
            ]);
        if ($validate->fails()) {
            return redirect('/banner')->with('error', $validate->errors()->first());
        }


        $image = $request->icon;
        $filenameWithExt = $image->getClientOriginalName();
        $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
        $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
        $filename = preg_replace("/\s+/", '-', $filename);
        $extension = $image->getClientOriginalExtension();
        $fileNameToStore = $filename . '_' . time() . '.' . $extension;
        $image_resize = Image::make($image->getRealPath());
        
        $save = $image_resize->save('images/' . $fileNameToStore);

        if ($save) {
            $banner = new Slider;
            $banner->onclick = $request->onclick;
            $banner->link = $request->link;
            $banner->bannertype = $request->bannertype;
            $banner->banner = $fileNameToStore;
            $res = $banner->save();
            if ($res) {
                return redirect('/banner')->with('success', 'Added Successfully!');
            } else {
                return redirect('/banner')->with('error', 'Technical Error!');
            }
        } else {
            return redirect('/banner')->with('error', 'Imagem not uploaded!');
        }
    }

    public function editBanner(Slider $id)
    {
        return $id;
    }

    public function updateBanner(Request $request)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        if ($request->icon) {

            $validate = Validator::make($request->all(), [
                'icon' => "required|mimes:jpeg,png,jpg",
            ],[
                'icon'=>'Please Select valid Image Supported Jpeg/Png'
                ]);
            if ($validate->fails()) {
                return redirect('/banner')->with('error', $validate->errors()->first());
            }

            $image = $request->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());
            
            $save = $image_resize->save('images/' . $fileNameToStore);
            $image_path = "/images/" . $request->oldicon;
            if (File::exists($image_path)) {
                File::delete($image_path);
            }

            $icon = $fileNameToStore;
        } else {
            $icon = $request->oldicon;
        }

        if ($icon) {
            $banner = Slider::find($request->id);
            $banner->onclick = $request->onclick;
            $banner->link = $request->link;
            $banner->bannertype = $request->bannertype;
            $banner->banner = $icon;
            $res = $banner->save();
            if ($res) {
                return redirect('/banner')->with('success', 'Added Successfully!');
            } else {
                return redirect('/banner')->with('error', 'Technical Error!');
            }
        } else {
            return redirect('/banner')->with('error', 'Imagem not uploaded!');
        }
    }

    public function destroyBanner($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        $banner = Slider::where('id', $id)->get()->first()->banner;
        $image_path = "/images/" . $banner;
        if (File::exists($image_path)) {
            File::delete($image_path);
        }
        Slider::find($id)->delete();
        return 1;
    }

    public function actionBanner(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = Slider::whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = Slider::whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }


   
    //Spin
    public function indexSpin()
    {
        $data = DB::table('spin_wheel')->orderBy('id', 'ASC')->paginate();
        return view('pages/spin', compact('data'));
    }

    public function storeSpin(Request $request)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $res = DB::table('spin_wheel')->insert([
            'coin' => $request->coin,
            'color' => $request->color,
            'created_at' => Carbon::now()
        ]);

        if ($res) {
            return redirect('/luckywheel')->with('success', 'Added Successfully!');
        } else {
            return redirect('/luckywheel')->with('error', 'Technical Error!');
        }
    }

    public function editSpin($id)
    {
        return DB::table('spin_wheel')->where('id', $id)->get();
    }

    public function updateSpin(Request $request)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $res = DB::table('spin_wheel')->where('id', $request->id)->update([
            'coin' => $request->coin,
            'color' => $request->color,
        ]);

        if ($res) {
            return redirect('/luckywheel')->with('success', 'Update Successfully!');
        } else {
            return redirect('/luckywheel')->with('error', 'Technical Error!');
        }
    }

    public function destroySpin($id)
    {
                
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        DB::table('spin_wheel')->where('id', $id)->delete();
        return 1;
    }

    // Faq
    public function indexfaq()
    {
        $lang=DB::table('lang')->get();
        $data = DB::table('faq')->orderBy('id', 'DESC')->paginate();
        return view('setting/faq/index',['data'=>$data,'lang'=>$lang]);
    }

    public function storefaq(Request $req)
    {
        
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $data = DB::table('faq')->insert([
            'lang' => $req->lang,
            'question' => $req->question,
            'answer' => $req->answer
        ]);

        if ($data) {
            return redirect('/faq')->with('success', 'Added Successfully!');
        } else {
            return redirect('/faq')->with('error', 'Technical Error!');
        }
    }

    public function editfaq($id)
    {
        return DB::table('faq')->where('id', $id)->get();
    }

    public function updatefaq(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $data = DB::table('faq')->where('id', $req->id)->update([
            'lang' => $req->lang,
            'question' => $req->question,
            'answer' => $req->answer
        ]);

        if ($data) {
            return redirect('/faq')->with('success', 'Update Successfully!');
        } else {
            return redirect('/faq')->with('error', 'Technical Error!');
        }
    }

    public function destroyfaq($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        DB::table('faq')->where('id', $id)->delete();
        return 1;
    }

    public function actionfaq(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = DB::table('faq')->whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = DB::table('faq')->whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }

    //coinstore
    public function indexStore()
    {
        $data = DB::table('coinstore')->orderBy('id')->paginate();
        return view('pages/coinstore', compact('data'));
    }

    public function storeCoin(Request $req)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $data = DB::table('coinstore')->insert([
            'title' => $req->title,
            'amount' => $req->amount,
            'currency' => $req->currency,
            'currency_posi' => $req->currency_posi,
            'coin' => $req->coin,
            'productID' => 'inapp_'. uniqid(),
            'country' => $req->country
        ]);

        if ($data) {
            return redirect('/coinstore')->with('success', 'Added Successfully!');
        } else {
            return redirect('/coinstore')->with('error', 'Technical Error!');
        }
    }

    public function editStore($id)
    {
        return DB::table('coinstore')->where('id', $id)->get();
    }

    public function updateStore(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        $data = DB::table('coinstore')->where('id', $req->id)->update([
            'title' => $req->title,
            'amount' => $req->amount,
            'currency' => $req->currency,
            'currency_posi' => $req->currency_posi,
            'productID' => 'inapp_'. uniqid(),
            'coin' => $req->coin,
            'country' => $req->country
        ]);

        if ($data) {
            return redirect('/coinstore')->with('success', 'Update Successfully!');
        } else {
            return redirect('/coinstore')->with('error', 'Technical Error!');
        }
    }

    public function destroyStore($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }
        DB::table('coinstore')->where('id', $id)->delete();
        return 1;
    }

    public function actionStore(Request $req)
    {
        
        if(auth()->user()->role_edit=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = DB::table('coinstore')->whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = DB::table('coinstore')->whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }

    //daily offer
    public function indexDaily()
    {
        $data = DB::table('tbl_dailyoffer')->paginate();
        return view('dailyoffer/index', compact('data'));
    }

    public function storeDaily(Request $req)
    {
        if(auth()->user()->role_create=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        $validate = Validator::make($req->all(), [
            'icon' => "required|mimes:jpeg,png,jpg",
        ],[
            'icon'=>'Please Select valid Image Supported Jpeg/Png'
            ]);
        if ($validate->fails()) {
            return redirect('/dailyoffer')->with('error', $validate->errors()->first());
        }
        
            $image = $req->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());
            
            $save = $image_resize->save('images/' . $fileNameToStore);

        $res = DB::table('tbl_dailyoffer')->insert([
            'title' => $req->title,
            'coin' => $req->coin,
            'image' => $fileNameToStore,
            'link' => $req->link,
            'task_limit' => $req->task_limit,
            'country' => $req->country,
            'description' => $req->details
        ]);

        if ($res) {
            return redirect('/dailyoffer')->with('success', 'Added Successfully');
        } else {
            return redirect('/dailyoffer/add')->with('error', 'Technical Error');
        }
    }

    public function editDaily($id)
    {
        $data = DB::table('tbl_dailyoffer')->where('id', $id)->get();
        return view('dailyoffer/edit', compact('data'));
    }

    public function viewDaily($id)
    {
        $data = DB::table('tbl_dailyoffer')->where('id', $id)->get();
        return view('dailyoffer/view', compact('data'));
    }

    public function updateDaily(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        
        if ($req->icon) {

            $validate = Validator::make($req->all(), [
                'icon' => "required|mimes:jpeg,png,jpg",
            ],[
                'icon'=>'Please Select valid Image Supported Jpeg/Png'
                ]);
            if ($validate->fails()) {
                return redirect('/dailyoffer')->with('error', $validate->errors()->first());
            }
            
            $image = $req->icon;
            $filenameWithExt = $image->getClientOriginalName();
            $filename = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $filename = preg_replace("/[^A-Za-z0-9 ]/", '', $filename);
            $filename = preg_replace("/\s+/", '-', $filename);
            $extension = $image->getClientOriginalExtension();
            $fileNameToStore = $filename . '_' . time() . '.' . $extension;
            $image_resize = Image::make($image->getRealPath());
            
            $save = $image_resize->save('images/' . $fileNameToStore);
            
            try {
                $image_path = "/images/" . $req->oldimage;
                if (File::exists($image_path)) {
                    File::delete($image_path);
                }
            
            } catch (\Exception $e) {}
            

            $icon = $fileNameToStore;
        } else {
            $icon = $request->oldimage;
        }
        
        $res = DB::table('tbl_dailyoffer')->where('id', $req->id)->update([
            'title' => $req->title,
            'coin' => $req->coin,
            'image' => $icon,
            'link' => $req->link,
            'task_limit' => $req->task_limit,
            'country' => $req->country,
            'description' => $req->details
        ]);

        return redirect('/dailyoffer')->with('success', 'Update Successfully');
    }

    public function destroyDaily($id)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        DB::table('tbl_dailyoffer')->where('id', $id)->delete();
        return 1;
    }

    public function actionDaily(Request $req)
    {
        if(auth()->user()->role_delete=='false'){
            return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
        }

        if ($req->status == "enable") {
            $update = DB::table('tbl_dailyoffer')->whereIn('id', explode(",", $req->id))->update(['status' => 0]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        } else if ($req->status == "disable") {
            $update = DB::table('tbl_dailyoffer')->whereIn('id', explode(",", $req->id))->update(['status' => 1]);
            if ($update) {
                return 1;
            } else {
                return "not updated";
            }
        }
    }

    public function pendingDaily()
    {

        $data = DB::table('tbl_dailyoffer')->join('data_dailyoffer', 'data_dailyoffer.survey_id', '=', 'tbl_dailyoffer.id')
            ->select('data_dailyoffer.*', 'tbl_dailyoffer.description', 'tbl_dailyoffer.title', 'tbl_dailyoffer.coin', 'tbl_dailyoffer.link')
            ->where('data_dailyoffer.taskStatus',0)
            ->orderBy('data_dailyoffer.id','DESC')->paginate();

        return view('dailyoffer/pending', compact('data'));
    }
    
    public function viewApproveDaily()
    {

        $data = DB::table('tbl_dailyoffer')->join('data_dailyoffer', 'data_dailyoffer.survey_id', '=', 'tbl_dailyoffer.id')
            ->select('data_dailyoffer.*', 'tbl_dailyoffer.description', 'tbl_dailyoffer.title', 'tbl_dailyoffer.coin', 'tbl_dailyoffer.link')
            ->where('data_dailyoffer.taskStatus',1)
            ->orderBy('data_dailyoffer.id','DESC')->paginate();

        return view('dailyoffer/approved', compact('data'));
    }

    public function approveDaily($id)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        if ($data = DB::table('data_dailyoffer')->where('id', $id)->get()) {
            $do = DB::table('tbl_dailyoffer')->where('id', $data[0]->survey_id)->get();
            $u = Users::find($data[0]->user_id);
            $tot = $u->balance + $do[0]->coin;
            $u->balance = $tot;
            $u->save();

            DB::table('data_dailyoffer')->where('id', $id)->update(['taskStatus' =>1, 'updated_at' => Carbon::now()]);
            DB::table('tbl_noti')->insert(['user_id' => $data[0]->user_id, 'title' => $do[0]->title, 'msg' => 'Daily Offer Completed', 'created_at' => Carbon::now()]);
            DB::table('transaction')
                ->insert([
                    'tran_type' => 'credit',
                    'user_id' => $data[0]->user_id,
                    'type' => $do[0]->title,
                    'amount' => $do[0]->coin,
                    'remained_balance' => $tot,
                    'remarks' => 'Daily Offer Completed'
                ]);

            return redirect('/dailyoffer/pending')->with('success', 'Approved Successfully');
        } else {
            return redirect()->back()->withErrors(['msgError' => 'Survey Not Found']);
        }
    }

    public function rejectDaily(Request $req)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }

        if ($data = DB::table('data_dailyoffer')->where('id', $req->id)->get()) {
            $do = DB::table('tbl_dailyoffer')->where('id', $data[0]->survey_id)->get();
            DB::table('tbl_noti')->insert(['user_id' => $data[0]->user_id, 'title' =>'Offer '.$do[0]->title.' Rejected', 'msg' => $req->remark, 'created_at' => Carbon::now()]);
            DB::table('tbl_dailyoffer')->where('id', $data[0]->survey_id)->update(['views' => ($do[0]->views - 1)]);
            
            try {
                $imagePath = public_path('images/dailyoffer/'.$data[0]->image);
                if(File::exists($imagePath)){
                  unlink($imagePath);
                }
            } catch (\Exception $e) {}
            
            DB::table('data_dailyoffer')->where('id', $req->id)->delete();
            
            DB::table('global_msg')->insert([
                'user_id' => $data[0]->user_id,
                'title' => 'Offer '.$do[0]->title.' Rejected',
                'msg' => $req->remark,
                'btn_name' => 'Complete again',
                'btn_action' => 'daily_offer',
                'error' => 'true',
            ]);
            
            return redirect('/dailyoffer/pending')->with('success', 'Reject Successfully');
        } else {
            return redirect()->back()->withErrors(['msgError' => 'Survey Not Found']);
        }
    }

    // active ticket

    public function activeTicket()
    {
        $data = DB::table('support_ticket')->where('status', '!=', 2)->paginate();
        return view('support/active', compact('data'));
    }

    public function closedTicket()
    {
        $data = DB::table('support_ticket')->where('status', '=', 2)->paginate();
        return view('support/closed', compact('data'));
    }


    public function updateTicket($status, $id)
    {
        if(auth()->user()->role_edit=='false'){
            return redirect()->back()->withErrors(['msgError' =>DB::table('alias')->where('tag','permission_error')->get()->first()->description]);
        }
        DB::table('support_ticket')->where('id', $id)->update(['status' => $status, 'updated_at' => Carbon::now()]);
        $t = DB::table('support_ticket')->where('id', $id)->get();
        DB::table('tbl_noti')->insert(['user_id' => $t[0]->user_id, 'title' => $t[0]->subject, 'msg' => "Ticket Status Updated", 'created_at' => Carbon::now()]);

        return redirect('/support/ticket_active')->with('success', 'Ticket Status Update Successfully');
    }

    public function actionTicket(Request $req)
    {
        if ($req->status == "delete") {
            
            if(auth()->user()->role_delete=='false'){
                return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
            }
            
            DB::table('support_ticket')->whereIn('id', explode(",", $req->id))->delete();
            return 1;
        } else if ($req->status == "onprocess") {
            
            if(auth()->user()->role_edit=='false'){
                return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
            }

            $arr = explode(",", $req->id);
            $cnt = count($arr);
            for ($i = 0; $i < $cnt; $i++) {
                DB::table('support_ticket')->where('id', $arr[$i])->update(['status' => 1, 'updated_at' => Carbon::now()]);
                $t = DB::table('support_ticket')->where('id', $arr[$i])->get();
                DB::table('tbl_noti')->insert(['user_id' => $t[0]->user_id, 'title' => $t[0]->subject, 'msg' => "Ticket Status Updated", 'created_at' => Carbon::now()]);
            }

            return 1;
        } else if ($req->status == "closed") {
            
            if(auth()->user()->role_edit=='false'){
                return DB::table('alias')->where('tag','permission_error')->get()->first()->description;
            }

            $arr = explode(",", $req->id);
            $cnt = count($arr);
            for ($i = 0; $i < $cnt; $i++) {
                DB::table('support_ticket')->where('id', $arr[$i])->update(['status' => 2, 'updated_at' => Carbon::now()]);
                $t = DB::table('support_ticket')->where('id', $arr[$i])->get();
                DB::table('tbl_noti')->insert(['user_id' => $t[0]->user_id, 'title' => $t[0]->subject, 'msg' => "Ticket Status Updated", 'created_at' => Carbon::now()]);
            }

            return 1;
        }
    }
}
