<?php

namespace App\Http\Controllers;

use App\Models\Users;
use App\Models\MOfferwall;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use File,Image;
use Illuminate\Support\Facades\Validator;

class Fun extends Controller
{
    public static function StoreImage($location,$width,$height,$req,$filename,$update){

        $validate = Validator::make($req->all(), [
            $filename => "required|mimes:jpeg,png,jpg",
        ],[
            $filename=>'Please Select valid Image Supported Jpeg/Png'
            ]);
        if ($validate->fails()) {
            return null;
        }
        
        $image = $req->icon;
        $filenameWithExt = $image->getClientOriginalName();
        $extension = $image->getClientOriginalExtension();
        $fileNameToStore = uniqid() . '_' . time() . '.' . $extension;
        $image_resize = Image::make($image->getRealPath());
        if($width!=null||$height!=null){
           $image_resize->resize($width,$height);
        }
        $save = $image_resize->save('images/' . $fileNameToStore);
        
        if($update){
            if($location=="image"){
                Fun::removeImage('/images/',$req->oldicon);
            }
        }
        
        if($save){
            return $fileNameToStore;
        }else{
            return null;
        }
    }
    
    
    public static function removeImage($location,$filename){
        $image_path = $location.$filename;
        if($location!=null && $filename!=null){
            if (File::exists($image_path)) {
                File::delete($image_path);
            }
        }
    }
    
    public function privacyPolicy(){
         $db = DB::table('admin_key')->where('id',1)->select('privacy_policy')->get();
        return view('description',['data'=>$db[0]->privacy_policy]);
    }
    
    public function appAds(){
         $db = DB::table('admin_key')->where('id',1)->select('ads_txt')->get();
        return view('description',['data'=>$db[0]->ads_txt]);
    }
    
    public function accountDeleteView(){
        
        return view('account-delete'); 
        
    }
    
    function deleteuserAccount(Request $req){
        
         $validator = Validator::make($req->all(), [
            'email' => 'required|email',
            'name' => 'required|string',
            'level' => 'required|string',
            'coin' => 'required|string',
        ]);
        
        
        if ($validator->fails()) {
            return redirect('account-delete-submission')->with('error',$validator->errors()->first());
        }
        
        if($user=DB::table('customer')->where(['email'=>$req->email,'level'=>$req->level,'balance'=>$req->coin])->first()){
           
            $id = $user->cust_id;
            $email = $user->email;
            
            DB::table('delete_account')->insert(['email'=>$email]);
            
            DB::table('customer')->where('cust_id', $id)->delete();
            DB::table('transaction')->where('user_id', $id)->delete();
            DB::table('recharge_request')->where('user_id', $id)->delete();
            DB::table('data_dailyoffer')->where('user_id', $id)->delete();
            DB::table('monitor_report')->where('userid', $id)->delete();
            DB::table('task_count')->where('user_id', $id)->delete();
            DB::table('tbl_noti')->where('user_id', $id)->delete();
            DB::table('tbl_support')->where('user_id', $id)->delete();
            
          return redirect('account-delete-submission')->with('success','All Data has been delete successfully');

        }else{
            return redirect('account-delete-submission')->with('error','User not exist.');
            
        }

        
        
        
    }
    
}