<?php

namespace App\Http\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Image;
use File;
use Carbon\Carbon;

class LanguageController extends Controller
{


    public function index()
    {
        $data = DB::table('lang')->paginate(15);
        return view('language/language', compact('data'));
    }

    function edit($id){
        return DB::table('lang')->where('id',$id)->first();
    }

    public function indexData()
    {
        $lang=DB::table('lang')->get();
        if(isset(request()->lang)){
              $data=DB::table('lang_text')->where('lang',request()->lang)->orderBy('id','ASC')->get();
        }else{
            $data=DB::table('lang_text')->where('lang','en')->orderBy('id','ASC')->get();
        }      
        
        return view('language.lang-data',['data'=>$data,'lang'=>$lang]);
    }

    function update(Request $req){

         if ($req->icon) {
            $filename =  Fun::StoreImage("image", null, null, $req, $req->oldicon, true);
        } else {
           $filename=$req->oldicon;
        }

        DB::table('lang')->where('id',$req->id)->update(['title'=>$req->title,'image'=>$filename]);
        return redirect('/language')->with('success', 'Update Successfully!');

    }
    
    function updateLangText(Request $req){
        
      $count= count($req->lang_id);  
      
      for($i=0; $i<$count; $i++){
          DB::table('lang_text')->where('id',$req->lang_id[$i])->update(['txt_value'=>$req->langval[$i]]);
      }
        
      return redirect('/language/data?lang='.$req->selected_lang)->with('success', 'Update Successfully!');
    } 
    
}