@extends('user_type.guest', ['parentFolder' => 'pages', 'childFolder' => 'resetPasswprd'])

@section('content')

    <div class="page-header section-height-75">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-lg-5 col-md-6 d-flex flex-column mx-auto">
                    <div class="card card-plain mt-8">
                        <div class="card-header pb-0 text-left bg-transparent">
                            <h4 class="mb-2">{{ env('APP_NAME') }}</h4>
                            <h6 class="mb-1">Account Delete Request</h6>
                            <p>Note: when you submit account delete request all data will be deleted instantly. after request submit data can't be recover.</p>
                        </div>
                        <div class="card-body">
                            @if(session('error'))
                            <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                                <span class="alert-text text-white">
                                 {{ session('error') }}</span>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                                    <i class="fa fa-close" aria-hidden="true"></i>
                                </button>
                            </div>
                            @endif
                            @if(session('success'))
                            <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                                <span class="alert-text text-white">
                                {{ session('success') }}</span>
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                                    <i class="fa fa-close" aria-hidden="true"></i>
                                </button>
                            </div>
                            @endif
                            <form role="form" action="/account-delete-update" method="POST">
                                @csrf
                                <input type="hidden" name="token" value="">
                                
                                <div>
                                    <label for="email">Account Username</label>
                                    <div class="">
                                        <input id="email" name="name" type="text" class="form-control" placeholder="John" aria-label="John" aria-describedby="email-addon" value="{{ old('name') }}" required>
                                        @error('name')
                                            <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                                                                
                               <div class="mt-2">
                                    <label for="email">Account Email</label>
                                    <div class="">
                                        <input id="email" name="email" type="email" class="form-control" placeholder="Email" aria-label="Email" aria-describedby="email-addon" value="{{ old('email') }}" required>
                                        @error('email')
                                            <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                                
                                <hr>
                                <p>for security purpose you need to enter correct answer this will be confirmation that you are self deleting account not any other one.</p>
                                <hr>
                                <div class="mt-2">
                                    <label for="password">What is Current Level of your account [ you can check in your profile section ] </label>
                                    <div class="">
                                        <input id="password" name="level" type="number" class="form-control" placeholder="level" aria-label="5" aria-describedby="5" required>
                                        @error('level')
                                            <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="mt-2">
                                    <label for="password_confirmation">What is Current Coins in your account [ you can check in your profile section ]</label>
                                    <div class="">
                                        <input name="coin" type="number" class="form-control" placeholder="coin" aria-label="coin" aria-describedby="coin" required>
                                        @error('coin')
                                            <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                        @enderror
                                    </div>
                                </div>
                                <div class="text-center">
                                    <button type="submit" class="btn bg-gradient-info w-100 mt-4 mb-0">Delete All Data</button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="oblique position-absolute top-0 h-100 d-md-block d-none me-n8">
                        <div class="oblique-image bg-cover position-absolute fixed-top ms-auto h-100 z-index-0 ms-n6" style="background-image:url('../assets/img/curved-images/curved6.jpg')"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection