@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])


@section('content')
<style>
    /* HIDE RADIO */
    [type=radio] {
        position: absolute;
        opacity: 0;
        width: 0;
        height: 0;
    }

    /* IMAGE STYLES */
    [type=radio]+img {
        cursor: pointer;
    }

    /* CHECKED STYLES */
    [type=radio]:checked+img {
        outline: 2px solid #f00;
    }
</style>
<main class="main-content mt-1 border-radius-lg">
    <div class="container-fluid py-4">
        <div class="row">
            <div class="col-9 mx-auto">
                @if($errors->get('msgError'))
                  <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
                    <span class="alert-text text-white">
                      {{$errors->first()}}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                  </div>
                  @endif
                  @if(session('success'))
                  <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
                    <span class="alert-text text-white">
                      {{ session('success') }}</span>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                      <i class="fa fa-close" aria-hidden="true"></i>
                    </button>
                  </div>
                  @endif
                
                <div class="card card-body mt-4">
                    <h6 class="mb-0">Home Page Task Category</h6>
                    <p class="text-sm mb-0">Create Task Category</p>
                    <hr class="horizontal dark my-3">
                    <form action="/app-setting/homepage/store" method="POST" enctype="multipart/form-data">
                        @csrf
                        <input type="hidden" name="type" value="category">

                        
                        <div id="btnstyle0" class="form-group">
                                    <label for="categoryName" class="form-label">Select Category Style</label>
                                    <div class="">
                                        <label>
                                            <input type="radio" name="cat_theme" value="0" checked>
                                            <img src="{{URL::asset('assets/img/task/top_style1.png') }}"
                                                class="avatar avatar-xxl shadow" width="100" height="100"
                                                alt="Option 1">
                                            <label>

                                                <label>
                                                    <input type="radio" name="cat_theme" value="1">
                                                    <img src="{{URL::asset('assets/img/task/top_style2.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="cat_theme" value="2">
                                                    <img src="{{URL::asset('assets/img/task/top_style3.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>

                                                <label>
                                                    <input type="radio" name="cat_theme" value="3">
                                                    <img src="{{URL::asset('assets/img/task/top_style4.png') }}"
                                                        class="avatar avatar-xxl shadow" width="100" height="100"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="cat_theme" value="4">
                                                    <img src="{{URL::asset('assets/img/task/top_style5.png') }}"
                                                        class="avatar avatar-xxxl shadow" style="width:150px; height:100px;"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="cat_theme" value="5">
                                                    <img src="{{URL::asset('assets/img/task/top_style6.png') }}"
                                                        class="avatar avatar-xxxl shadow" style="width:150px; height:100px;"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="cat_theme" value="6">
                                                    <img src="{{URL::asset('assets/img/task/top_style7.png') }}"
                                                        class="avatar avatar-xxxl shadow" style="width:150px; height:100px;"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="cat_theme" value="7">
                                                    <img src="{{URL::asset('assets/img/task/top_style8.png') }}"
                                                        class="avatar avatar-xxxl shadow" style="width:300px; height:100px;"
                                                        alt="Option 2">
                                                </label>
                                                
                                                <label>
                                                    <input type="radio" name="cat_theme" value="8">
                                                    <img src="{{URL::asset('assets/img/task/top_style9.png') }}"
                                                        class="avatar avatar-xxxl shadow" style="width:300px; height:100px;"
                                                        alt="Option 2">
                                                </label>
                                                
                                    </div>
                                </div>
                        
                         <div class="row">
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title English</label>
                                    <input type="text" class="form-control" name="title_en" placeholder="Play for reward" required>
                                </div>
                            </div>
                            
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title Arabic</label>
                                    <input type="text" class="form-control" name="title_ar" placeholder="Play for reward" required>
                                </div>
                            </div>
                            
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title Indonesian</label>
                                    <input type="text" class="form-control" name="title_in" placeholder="Play for reward" required>
                                </div>
                            </div>
                            
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title French</label>
                                    <input type="text" class="form-control" name="title_fr" placeholder="Play for reward" required>
                                </div>
                            </div>
                
                        </div>
                        
                         <div class="row">
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title German</label>
                                    <input type="text" class="form-control" name="title_de" placeholder="Play for reward" required>
                                </div>
                            </div>
                            
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title Spanish</label>
                                    <input type="text" class="form-control" name="title_es" placeholder="Play for reward" required>
                                </div>
                            </div>
                            
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title Vietnamese</label>
                                    <input type="text" class="form-control" name="title_vi" placeholder="Play for reward" required>
                                </div>
                            </div>
                            
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title Italian</label>
                                    <input type="text" class="form-control" name="title_it" placeholder="Play for reward" required>
                                </div>
                            </div>
                        
                        </div>
                    
                        <div class="row">
                            <div class="col-3">
                                <div class="form-group">
                                    <label for="recipient-name" class="form-label">Title Bangla</label>
                                    <input type="text" class="form-control" name="title_bn" placeholder="Play for reward" required>
                                </div>
                            </div>
                           
                            
                        </div>
                    
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Category Order</label>
                            <div class="">
                                <input type="number" class="form-control" placeholder="0,1" value="0" name="row_order"
                                    onfocus="focused(this)" onfocusout="defocused(this)" required>
                                @error('row_order')
                                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label for="categoryName" class="form-label">Layout Mode</label>
                            <div class="">
                                <select name="view_mode" class="form-control">
                                    <option value="0" selected>HORIZONTAL</option>
                                    <option value="1">VERTICAL</option>
                                    <option value="2">GRID VIEW [2]</option>
                                    <option value="3">GRID VIEW [3]</option>
                                    <option value="4">GRID VIEW [4]</option>
                                </select>
                            </div>
                        </div>


                        <div class="d-flex justify-content-end mt-4">
                            <a href="{{ url('/app-setting/homepage/category') }}" type="button" name="button"
                                class="btn btn-light m-0">BACK TO LIST</a>
                            <button type="submit" name="button" class="btn bg-gradient-primary m-0 ms-2">Add
                                </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</main>
@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="{{ URL::asset('assets/js/plugins/sweetalert.min.js') }}"></script>
<script src="{{ URL::asset('assets/js/plugins/action.js') }}"></script>

<script>



</script>
@endpush