@extends('user_type.auth', ['parentFolder' => 'language', 'childFolder' => ''])

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">Language Text</h5>
            <div class="ms-auto my-auto mt-2">
                <label class="text-sm">Select Language : </label>
                <select class="form-control"  onchange="javascript:location.href = this.value;">
                    @foreach($lang as $item)
                    <option value="/language/data?lang={{$item->code}}" {{ (request()->get('lang') == $item->code ) ? 'selected' : ''}} >{{$item->title}}</option>
                    @endforeach
                </select>   
            </div>
          </div>
          <div class="ms-auto my-auto mt-lg-0 mt-4">
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          
            <div class="col-lg-12 col-12 mx-auto p-5">
                  <form class="forms-sample" method="POST" action="/language/update-lang-txt" enctype="multipart/form-data">
                      <input type="hidden" value="{{request()->get('lang')}}" name="selected_lang">
                        @csrf
                    <div class="form-group row">
                        @if(count($data) > 0)
                        @foreach($data as $item)
                        <div class="col-sm-4 mt-2">
                            <label for="exampleInputPassword2" class="col-sm-12 col-form-label"><b>{{$item->txt_key}}</b></label>
                            <div class="col-sm-12">
                                <input type="hidden" class="form-control" name="lang_id[]" value="{{$item->id}}">
                                <input type="text" class="form-control" name="langval[]" value="{{$item->txt_value}}" placeholder=""
                                    required>
                            </div>
                        </div>

                        @endforeach
                        @endif
                    </div>

                    <button type="submit" class="btn btn-primary mr-2">
                        {{ __('Update')}}
                    </button>
                    </form>
                
            </div>
            </div>
          
      </div>
    </div>
  </div>
</div>

@endsection
@include('modal')
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
  });
  

</script>
@endpush