@extends('user_type.auth', ['parentFolder' => 'offer', 'childFolder' => ''])

 <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.0-rc.4/dist/css/tom-select.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.0-rc.4/dist/js/tom-select.complete.min.js"></script>
    
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">


<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">CpaLead Offers</h5>
              <div class="ms-auto my-auto mt-2">
                <label class="text-sm">Sort By offerwall Country: </label>
                <select class="form-control"  onchange="javascript:location.href = this.value;"  id="select-state" placeholder="Pick a Country...">
                   <option value="">Select a Country...</option>
                   @foreach($cn as $item)
                    <option value="/offers/cpeadlead_offers?c={{$item->iso}}" {{ (request()->get('c') == $item->iso ) ? 'selected' : ''}} >{{$item->name}}</option>
                   @endforeach
                    
                </select>   
            </div>
          </div>
      
          <div class="ms-auto my-auto mt-lg-0 mt-4">
            <div class="ms-auto my-auto">
               
            </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>OFFER ID</th>
                <th>ICON</th>
                <th>TITLE</th>
                <th>APP URL</th>
                <th>PAYOUT</th>
                <th>PAYOUT TYPE</th>
                <th>COUNTRY</th>
                <th>CATEGORY</th>
                <th>DESCRIPTION</th>
                <th>STATUS</th>
                <th>CREATED AT</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              @if(count($data) > 0)
              @foreach($data as $item)
              <tr id="{{$item['campid']}}">
                <td class="text-sm">{{$item['campid']}}</td>
                <td class="text-sm">
                  <span class="my-2 text-xs">
                    {{$item->image}}
                  </span>
                </td>
                <td class="text-sm">{{$item['title']}}</td>
                <td class="text-sm"><a href="{{$item['link']}}" target="_blank" class="text-info">Affiliate Link</a></td>
                <td class="text-sm">{{$item['amount']}} {{$item['payout_currency']}} </td>
                <td class="text-sm">{{$item['payout_type']}}</td>
                <td class="text-sm">{{$item['country']}}</td>
                <td class="text-sm">{{$item['category_name']}}</td>
                <td class="text-sm">{{ \Illuminate\Support\Str::limit(strip_tags($item['description']), 30, $end='...') }}</td>
                <td class="text-sm">
                 
            
                  <a href="{{ url('offers/edit/' . $item['campid']) }}" class="mx-3" data-bs-toggle="tooltip" data-bs-original-title="Edit">
                    <i class="fas fa-edit text-success"></i>
                  </a>
                 
                  <a href="#" data-id="" id="{{$item['campid']}}" class="mx-3 delete" data-bs-toggle="tooltip" data-bs-original-title="Delete">
                    <i class="fas fa-trash text-danger"></i>
                  </a>
                
                </td>
              </tr>
              @endforeach
              @else
              <tr>no content </tr>
              @endif
            </tbody>
          </table>
          <div class="d-flex" style="margin-left: 30px;">

            <!-- <button class="btn btn-icon btn-outline-dark ms-2 export" data-type="csv" type="button">
              <span class="btn-inner--icon"><i class="ni ni-archive-2"></i></span>
              <span class="btn-inner--text">Export CSV</span>
            </button> -->
          </div>
          
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
@include('modal')
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>


<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 50,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found"
      },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
      
        new TomSelect("#select-state",{
        create: false,
        sortField: {
            field: "text",
            direction: "asc"
        }
    });
  });

     $("body").on("click", ".viewpostback", function () {
        var current_object = $(this);
        var id = current_object.attr('id');
        $('#postbackmodal').modal('show');
       $("#pb").text(id);
   });
  
  
</script>
@endpush