@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

 <link href="https://cdn.jsdelivr.net/npm/tom-select@2.0.0-rc.4/dist/css/tom-select.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/tom-select@2.0.0-rc.4/dist/js/tom-select.complete.min.js"></script>
    
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">


<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">Offertoro Offers</h5>
              <div class="ms-auto my-auto mt-2">
                <label class="text-sm">Sort By offerwall Country: </label>
                <select class="form-control"  onchange="javascript:location.href = this.value;"  id="select-state" placeholder="Pick a Country...">
                   <option value="">Select a Country...</option>
                   @foreach($cn as $item)
                    <option value="/offers/offertoro_offers?c={{$item->iso}}" {{ (request()->get('c') == $item->iso || request()->get('c') == 'IN' ) ? 'selected' : ''}} >{{$item->name}}</option>
                   @endforeach
                    
                </select>   
            </div>
          </div>
      
          <div class="ms-auto my-auto mt-lg-0 mt-4">
            <div class="ms-auto my-auto">
               
            </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          
           <form action="/offers/updateSetting" method="POST">
                @csrf   
            <div class="row" style="margin-left:10px;">

                <div class="col-sm-3">
                    <label class="form-label mt-1">OfferToro App Id</label>
                    <div class="input-group">
                        <input class="form-control" type="text"  name="offertoro_appid" value="{{$db[0]->offertoro_appid}}" placeholder="xxxx" required>
                    </div>
                </div>
                
                <div class="col-sm-3">
                    <label class="form-label mt-1">OfferToro Pub ID</label>
                    <div class="input-group">
                        <input class="form-control" type="text"  name="offertoro_pubid" value="{{$db[0]->offertoro_pubid}}" placeholder="xxx" required>
                    </div>
                </div>
                
                <div class="col-sm-3">
                    <label class="form-label mt-1">Offertoro Secret</label>
                    <div class="input-group">
                        <input class="form-control" type="text"  name="offertoro_secret" value="{{$db[0]->offertoro_secret}}" placeholder="xxxxx" required>
                    </div>
                </div>
                
                <div class="col-sm-3 mt-4">
                    <div class="input-group">
                        <button type="submit" class="btn bg-gradient-dark btn-lg ">Update</button>
                    </div>
                </div>
                </form>
            </div> 
            
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>OFFER ID</th>
                <th>ICON</th>
                <th>TITLE</th>
                <th>APP URL</th>
                <th>PAYOUT</th>
                <th>PAYOUT TYPE</th>
                <th>COUNTRY</th>
                <th>CATEGORY</th>
                <th>DESCRIPTION</th>
                <th>STATUS</th>
                <th>CREATED AT</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
               
             
              @if(count($data) > 0)
              @foreach($data as $item)
              
              <tr id="{{$item['offer_id']}}">
                <td class="text-sm">{{$item['offer_id']}}</td>
                <td class="text-sm">
                  <span class="my-2 text-xs">
                    <img src="{{$item['image_url']}}" class="avatar avatar-xl shadow">
                  </span>
                </td>
                <td class="text-sm">{{$item['offer_name']}}</td>
                <td class="text-sm"><a href="{{$item['offer_url']}}" target="_blank" class="text-info">Offer Link</a></td>
                <td class="text-sm">{{$item['payout']}} </td>
                <td class="text-sm">{{$item['payout_type']}}</td>
                <td class="text-sm">{{\Illuminate\Support\Str::limit(strip_tags(implode(",",$item['countries'])), 30, $end='...') }}</td>
                <td class="text-sm">{{implode(",",$item['category'])}}</td>
                <td class="text-sm">{{ \Illuminate\Support\Str::limit(strip_tags($item['offer_desc']), 30, $end='...') }}</td>
                <td class="text-sm">
                 
                <form action="/offers/addcpi" method="POST">
                @csrf                  
                <input type="hidden" name="id" value="{{$item['offer_id']}}">
                <input type="hidden" name="offer_name" value="{{$item['offer_name']}}">
                <input type="hidden" name="image_url" value="{{$item['image_url']}}">
                <input type="hidden" name="offer_url" value="{{str_replace('tag=[tag]', 'tag=mobile', $item['offer_url_easy'])}}">
                <input type="hidden" name="payout" value="{{$item['payout']}}">
                <input type="hidden" name="amount" value="{{$item['amount']}}">
                <input type="hidden" name="payout_type" value="{{$item['payout_type']}}">
                <input type="hidden" name="countries" value="{{implode(",",$item['countries'])}}">
                <input type="hidden" name="offer_desc" value="{{$item['offer_desc']}}">
                    
                    @if(\App\Models\AppOffer::getCount($item['offer_id'])==0)
                  <button type="submit" name="button" class="btn btn-primary mx-3" data-bs-toggle="tooltip" data-bs-original-title="Add"> ADD
                  </button>
                  @else
                   <button  class="btn btn-success mx-3" data-bs-toggle="tooltip" data-bs-original-title="Add"> Already Added
                  </button>
                  @endif
                 </form> 
                 
                </td>
                
              </tr>
              @endforeach
              @else
              <tr>no content </tr>
              @endif
             
            </tbody>
          </table>
          <div class="d-flex" style="margin-left: 30px;">

            <!-- <button class="btn btn-icon btn-outline-dark ms-2 export" data-type="csv" type="button">
              <span class="btn-inner--icon"><i class="ni ni-archive-2"></i></span>
              <span class="btn-inner--text">Export CSV</span>
            </button> -->
          </div>
          
        </div>
      </div>
    </div>
  </div>
</div>

@endsection
@include('modal')
@push('js')
<script src="{{ URL::asset('assets/js/plugins/datatables.js') }}"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>


<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 50,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found"
      },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
      
        new TomSelect("#select-state",{
        create: false,
        sortField: {
            field: "text",
            direction: "asc"
        }
    });
  });

     $("body").on("click", ".viewpostback", function () {
        var current_object = $(this);
        var id = current_object.attr('id');
        $('#postbackmodal').modal('show');
       $("#pb").text(id);
   });
  
  
</script>
@endpush