@extends('user_type.auth', ['parentFolder' => 'offerwall', 'childFolder' => 'none'])

@section('content')
<main class="main-content mt-1 border-radius-lg">
    <div class="container my-3 py-3 d-flex flex-column">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        
        <div class="row mb-5 justify-content-center align-items-center">
            <div class="col-lg-9 col-12 mx-auto">
                 <div class="row">
                    <div class="col-4"></div>
                    <div class="col-4">
                        <div class="card card-body text-center">
                            <div class="row col-lg-12">
                                <div class="col-sm-12">
                                    <div class="avatar avatar-xxl">
                                        <div>
                                            <span class="h-12 w-12 rounded-full overflow-hidden bg-gray-100 ">
                                                <img src="{{ url('images/'.$data->image)}}" class="avatar-xl shadow align-items-center" id="imgDisplay" alt="Profile Photo">
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <!-- <div class="h-100"> -->
                                        <h5 class="mb-1 font-weight-bolder">
                                            {{$data->title}}
                                        </h5>
                                        <p class="mb-0 font-weight-bold text-sm">
                                            Rewarded Ads
                                        </p>
                                    <!-- </div> -->
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="col-4"></div>
                </div>
                <!-- Card Basic Info -->
                <div class="card mt-4" id="basic-info">
                    <div class="card-header">
                        <h5>VideoWall Configuration</h5>
                    </div>
                    <div class="card-body pt-0">
                        <form action="/offerwall/videowall/update" method="POST" enctype="multipart/form-data">
                            @csrf
                            <input type="hidden" name="id" value="{{$data->id}}"/>
                            <input type="hidden" name="oldimage" value="{{$data->image}}"/>

                            <div class="row">
                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Videowall Name</label>
                                    <div class="input-group">
                                        <input class="form-control" name="title" type="text"  value="{{$data->title}}"  placeholder="Ironsource " required>
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Videocall Icon</label>
                                    <div class="input-group">
                                        <input class="form-control" name="icon" type="file">
                                    </div>
                                </div>

                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Videocall Description</label>
                                    <div class="input-group">
                                        <input class="form-control"  name="subtitle"  value="{{$data->subtitle}}" type="text" placeholder="Best Offers etc" required>
                                    </div>
                                </div>
                                
                                <div class="col-sm-12">
                                    <label class="form-label mt-4">Videowall Coin</label>
                                    <div class="input-group">
                                        <input class="form-control"  name="coin"  value="{{$data->coin}}" type="number" placeholder="1" required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <label class="form-label mt-4">VideoWall in Oroder </label>
                                    <div class="input-group">
                                        <input class="form-control"  name="row_order"  value="{{$data->row_order}}" type="number" placeholder="1" required>
                                    </div>
                                </div>

                                <div class="row">
                                @foreach((array)$network as $item)
                                <label class="form-label mt-4">{{ $item['name']}}</label>
                                <div class="input-group">
                                    <input  class="form-control" type="text" name="keyval[]" placeholder="{{ $item['name']}}" value="{{ $item['value']}}" required>
                                </div>

                                @endforeach
                                </div>
                              
                            </div>
                    </div>
                    <div class="">
                        <button type="submit" class="btn bg-gradient-dark btn-sm mb-6 ms-6 mb-0">Save changes</button>
                    </div>
                </div>

            </div>
        </div>
    </div>
</main>
@endsection
@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>
<script>
    // $("#file-input").change(function(){
    //     readURL(this);
    // });
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
    $(document).ready(function() {
        $("#alert-success").delay(3000).slideUp(300);
        $("#conv").hide();

    });

    if (document.getElementById('choices-tag')) {
        var tag = document.getElementById('choices-tag');
        const example = new Choices(tag);
    }

    $('#choices-tag').change(function() {
        var optVal = $("#choices-tag option:selected").val();
        if (optVal == 1) {
            $('#conv').show();
        } else {
            $('#conv').hide();
        }
    });
</script>
@endpush