
<meta name="csrf-token" content="{{ csrf_token() }}">
<div class="row">
  <div class="col-12">
    <div class="">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div class="ms-auto my-auto mt-lg-0 ">
          <div class="ms-auto my-auto">
              <!--<button class="btn btn-outline-dark sub_chk_all"> Select All </button>-->
            <div class="dropdown d-inline " style="margin-left: 10px; margin-right: 10px;">
              <a href="javascript:;" class="btn btn-outline-dark dropdown-toggle " data-bs-toggle="dropdown" id="navbarDropdownMenuLink2">
                Action
              </a>
              <ul class="dropdown-menu dropdown-menu-lg-start px-2 py-3" aria-labelledby="navbarDropdownMenuLink2" data-popper-placement="left-start">
                <li><a class="dropdown-item border-radius-md" href="javascript:;" id="enable" data-id="lang">Eanble</a></li>
                <li><a class="dropdown-item border-radius-md" href="javascript:;" id="disable" data-id="lang">Disable</a></li>
              </ul>
            </div>
                <a href="#" class="btn bg-gradient-info btn-sm mb-0 addlang">+&nbsp; ADD LANGUAGE</a>
              </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>SELECT</th>
                <th>LANGUAGE ICON</th>
                <th>LANGUAGE TITLE</th>
                <th>LANGUAGE CODE</th>
                <th>STATUS</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              @if(count($data) > 0)
              @foreach($data as $item)
              <tr id="{{$item->id}}">
                <td class="text-sm">
                  <div class="form-check my-auto">
                  <input class="form-check-input sub_chk" type="checkbox" id="customCheck1" data-id="{{$item->id}}" value="{{$item->id}}">
                  </div>
                </td>
                <td class="text-sm">
                    <span class="my-2 text-xs">
                            <img src="{{ url('images/'.$item->image) }}" class="avatar avatar-xl shadow" alt="Responsive image">
                    </span>
                </td>
                <td class="text-sm">{{$item->title}}</td>
                <td class="text-sm">{{$item->lang_code}}</td>
                <td class="text-sm" >
                  @if($item->status==0)
                  <span class="badge bg-success">Active</span>
                  @else
                  <span class="badge bg-danger">Disabled</span>
                  @endif
                </td>
                <td class="text-sm">
                  <a href="#" class="mx-3 editLang" data-bs-toggle="tooltip" id="{{$item->id}}"  data-bs-original-title="Edit">
                    <i class="fas fa-edit text-success"></i>
                  </a>
                  
                </td>
              </tr>
              @endforeach
              @else
              <tr>no content </tr>
              @endif
            </tbody>
          </table>
          {{$data->links('components.paginate')}}
        </div>
      </div>
    </div>
  </div>
</div>

<!-- update lang modal -->
<div class="modal fade" id="langUpdateModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalMessageTitle"
    aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Update Language</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                    <span aria-hidden="false">×</span>
                </button>
            </div>
            <div class="modal-body">
                <form action="/setting/update" method="POST" enctype="multipart/form-data">
                    @csrf

                    <input type="hidden" name="type" value="lang">
                    <input type="hidden" name="id" id="lang_id">
                    <input type="hidden" name="oldicon" id="lang_icon">

                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Language Title</label>
                        <input type="text" class="form-control" name="title" id="lang_title"
                            placeholder="English" required>
                    </div>

                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Language Icon</label>
                        <input type="file" class="form-control" name="icon">
                    </div>

                    <div class="form-group">
                        <label for="recipient-name" class="form-label">Language Code</label>
                        <input type="text" class="form-control" name="lang_code" id="lang_code" placeholder="en"
                            required>
                    </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn bg-gradient-secondary" data-bs-dismiss="modal">Close</button>
                <button type="submit" class="btn bg-gradient-info">Update</button>

                </form>
            </div>
        </div>
    </div>
</div>
