@extends('user_type.auth', ['parentFolder' => 'admin-setting', 'childFolder' => 'app-setting'])

@section('content')
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
        
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        
        <div class="card card-body mt-4">
            <h6 class="mb-0">Fraud & Prevention</h6>
            <p class="text-sm mb-0">Manage App Security</p>
            <hr class="horizontal dark my-3">
            <form action="/setting/update" method="POST">
                @csrf
                <input type="hidden" name="type" value="security">

                <br>
                
               <div class="col-6">
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">Max Account Using Same IP{ How many account user can create from same IP Address}</label>
                    <input type="number" class="form-control" name="oneip_device"  value="{{$data[0]->oneip_device}}" placeholder="3" required>
                    
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">VPN Required Message </label>
                    <input type="text" class="form-control" name="vpn_required_msg"  value="{{$data[0]->vpn_required_msg}}" placeholder="For Use This App you need to connect VPN">
                    
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">Block Country Access with ISO Code</label>
                    <input type="text" class="form-control" name="block_country_iso"  value="{{$data[0]->block_country_iso}}" placeholder="US,IN ">
                    
                    <hr class="horizontal dark my-2">
                    <label for="projectName" class="form-label">Block Country Access Message</label>
                    <input type="text" class="form-control" name="block_country_msg"  value="{{$data[0]->block_country_msg}}" placeholder="Sorry Our App Not Available in your Country">
               </div>
               <br>

                <div class="row" style="margin-left:20px">
                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/vpn.png')}}" class="avatar avatar-ssl shadow">
                                </span>
                            </div>

                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" name="block_vpn" id="fcustomCheck1" {{($data[0]->block_vpn == 'true') ? 'checked' : '' }}>
                                                Block Vpn Access </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        User Cannot Access App with Vpn.</figcaption>
                                </figure>
                            </div>

                        </div>
                    </div>
                    <div class="col-1"></div>

                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/blockroot.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-8">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1"
                                                    name="block_root_device" {{($data[0]->block_root_device == 'true') ? 'checked' : '' }}>
                                                Block Rooted Devices </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        App will not work on Rooted device.</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                </div>

                <div class="row mt-3" style="margin-left:20px">
                    
                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/vpn.png')}}" class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1" name="vpn_monitor" {{($data[0]->vpn_monitor == 'true') ? 'checked' : '' }}>
                                                Silently Monitor VPN </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        Silently record how many time and which date user used VPN.</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                    <div class="col-5 card shadow-none border h-100 ">
                    <div class="row">
                        <div class="col-sm-1 m-2" style="width:60px;">
                            <span class="my-2 text-xs">
                                <img src="{{URL::asset('assets/img/blockroot.png')}}" class="avatar avatar-ssl shadow">
                            </span>
                        </div>
                        <div class="col-sm-6">
                            <figure>
                                <blockquote class="blockquote">
                                    <h6>
                                        <p class="ps-2">
                                        <div class="form-check" style="margin-left:5px;"><input class="form-check-input"
                                                type="checkbox" id="fcustomCheck1" name="auto_banroot" {{($data[0]->auto_banroot == 'true') ? 'checked' : '' }}>
                                            Auto Ban Rooted Device </p>
                                        </div>
                                    </h6>
                                </blockquote>
                                <figcaption class="blockquote-footer ps-3">
                                    Auto ban account who used in rooted device..</figcaption>
                            </figure>
                        </div>
                    </div>
                </div>
                    <div class="col-1"></div>

                </div>

                <div class="row mt-3"  style="margin-left:20px">
                    
                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/vpn.png')}}" class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1" name="auto_banVpn" {{($data[0]->auto_banVpn == 'true') ? 'checked' : '' }}>
                                                Auto Ban VPN User </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        If user use vpn then his account block automatically.</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                    <div class="col-5 card shadow-none border h-100 ">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/onedevice.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1"
                                                     name="onedevice" {{($data[0]->onedevice == 'true') ? 'checked' : '' }}>
                                                One Device One Account </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        User Can Create Only One Account in one device.</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                </div>
                
                <div class="row mt-3"  style="margin-left:20px">
                    
                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/app_clon.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1"  name="vpn_required" {{($data[0]->vpn_required == 'true') ? 'checked' : '' }}>
                                                VPN Required </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        User Need to Use VPN in this App to Use App (not recommended)</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                    <div class="col-5 card shadow-none border h-100 ">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/onedevice.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1"
                                                    name="block_termux" {{($data[0]->block_termux == 'true') ? 'checked' : '' }}>
                                                Termux Block </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        if Termux App is Installed in Device then App not work.</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                </div>
                
                <div class="row mt-3"  style="margin-left:20px">
                    
                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/app_clon.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1"  name="app_clonning" {{($data[0]->app_clonning == 'true') ? 'checked' : '' }}>
                                                App Cloning Prevent</p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        User Cannot Work on Clonning App. if the option is activated</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                    <div class="col-5 card shadow-none border h-100 ">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/onedevice.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1"
                                                    name="block_devMode" {{($data[0]->block_devMode == 'true') ? 'checked' : '' }}>
                                                Developer Mode Prevent</p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        If Developer mode is enabled in device then app not work.</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                </div>
                
                 <div class="row mt-3"  style="margin-left:20px">
                    
                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/app_clon.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1" 
                                                    name="block_emulator" {{($data[0]->block_emulator == 'true') ? 'checked' : '' }}>
                                                Emulator Block </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        App will be not work on android emulator</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>
                    <div class="col-1"></div>

                    <div class="col-5 card shadow-none border h-100">
                        <div class="row">
                            <div class="col-sm-1 m-2" style="width:60px;">
                                <span class="my-2 text-xs">
                                    <img src="{{URL::asset('assets/img/app_clon.png')}}"
                                        class="avatar avatar-ssl shadow">
                                </span>
                            </div>
                            <div class="col-sm-6">
                                <figure>
                                    <blockquote class="blockquote">
                                        <h6>
                                            <p class="ps-2">
                                            <div class="form-check" style="margin-left:5px;"><input
                                                    class="form-check-input" type="checkbox" id="fcustomCheck1" 
                                                    name="block_country" {{($data[0]->block_country == 'true') ? 'checked' : '' }}>
                                                Country Block </p>
                                            </div>
                                        </h6>
                                    </blockquote>
                                    <figcaption class="blockquote-footer ps-3">
                                        App will be not work on Defined Country</figcaption>
                                </figure>
                            </div>
                        </div>
                    </div>

                    <div class="col-1"></div>

                </div>

               

                <p style="margin-top:5px; margin-left:10px">More function will be added on future Update..</p>
                <div class="d-flex justify-content-end mt-4">
                    <button type="submit" name="submit" class="btn bg-gradient-info float-left">Save</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>



@endpush