@extends('user_type.auth', ['parentFolder' => '', 'childFolder' => ''])

@section('content')
<div class="row">
    <div class="col-lg-9 col-12 mx-auto">
        @if($errors->get('msgError'))
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              {{$errors->first()}}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
          @if(session('success'))
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              {{ session('success') }}</span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          @endif
        <div class="card card-body mt-4">
            <h6 class="mb-0">Update Video</h6>
            <p class="text-sm mb-0">Fill Data</p>
            <form action="/videozone/update" method="POST">
            @csrf
            <input type="hidden" name="id" value="{{$data->id}}" >

            <hr class="horizontal dark my-3">
            <label for="projectName" class="form-label">Title</label>
            <input type="text" class="form-control" name="title" value="{{$data->title}}" id="projectName" placeholder="My Video">
            
             <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Video Thumbnail URL </label>
            <input type="text" class="form-control" name="thumb"  value="{{$data->thumb}}" placeholder="https://">
            @error('thumb')
                <p class="text-danger text-xs mt-2 mb-2">{{ $message }}</p>
            @enderror

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Video URL</label>
            <input type="text" class="form-control" name="url" value="{{$data->url}}" id="projectName" placeholder="https://www.youtube.com/watch?v=60ItHLz5WEA">

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Video Timer in Second (User need to must watch video for this time to get Reward)</label>
            <input type="number" class="form-control" name="timer" value="{{$data->timer}}"  id="projectName" placeholder="30">    

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Video Watch Coin (User Get After Complete task)</label>
            <input type="number" class="form-control" name="point" value="{{$data->point}}"  placeholder="5">

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Count of Users, who will Watch Video (Note: 0 = unlimited)</label>
            <input type="number" class="form-control" name="task_limit" value="{{$data->task_limit}}"  placeholder="0">

            <hr class="horizontal dark my-2">
            <label for="projectName" class="form-label">Video Available Country (For All Country just use = all)</label>
            <input type="text" class="form-control" name="country" value="{{$data->country}}"  placeholder="IN,US,all">
            
                        
            <hr class="horizontal dark my-2">
            <label class="form-label">Video Expire Date</label>
              <div class="input-group">
                    <input type="date" class="form-control" name="expire_at"  value="{{$data->expire_at}}"   placeholder="Pick a date" required>
              </div> 
            
            <hr class="horizontal dark my-2">
            <label class="form-label">Select AdNetwork</label>
              <div class="input-group">
                <select name="ad_type" class="form-control" required>
                  @foreach($ad as $item)
                  <option value="{{$item->type}}" {{($item->type == $data->ad_type ? 'selected' : '')}}>{{$item->title}}</option>
                  @endforeach
                </select>
              </div>
              
            <hr class="horizontal dark my-2">
            <label class="form-label">Play Video in ?</label>
              <div class="input-group">
                <select name="action_type" class="form-control" required>
                  <option value="browser" {{($item->type == $data->action_type ? 'selected' : '')}}>Browser (if app installed it will be open in app)</option>
                  <option value="custom" {{($item->type == $data->action_type ? 'selected' : '')}}>Google Chrome Custom Tab(in App)</option>
                </select>
              </div>  
              

            <div class="d-flex justify-content-end mt-4">
                <a href="{{ url('/videozone/active') }}" type="button" name="button" class="btn btn-light m-0">BACK TO LIST</a>
                <button type="submit" name="button" class="btn bg-gradient-info m-0 ms-2">Update Video</button>
            </div>
            </form>
        </div>
    </div>
</div>
@endsection

@push('js')
<script src="{{ URL::asset('assets/js/plugins/choices.min.js') }}"></script>
<script>
    if (document.getElementById('choices-tag')) {
      var tag = document.getElementById('choices-tag');
      const example = new Choices(tag);
    }
</script>
@endpush