

<?php $__env->startSection('content'); ?>

<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<div class="row">
  <div class="col-12">
    <div class="card">
      <!-- Card header -->
      <div class="card-header pb-0">
        <div class="d-lg-flex">
          <div>
            <h5 class="mb-0">Faq</h5>
          </div>
          <div class="ms-auto my-auto mt-lg-0 mt-4">
          <div class="ms-auto my-auto">
                <a href="#" class="btn bg-gradient-info btn-sm mb-0 addFaq">+&nbsp; ADD NEW</a>
              </div>
          </div>
        </div>
      </div>
      <div class="card-body px-0 pb-0">
        <div class="table-responsive">
          <?php if($errors->get('msgError')): ?>
          <div class="m-3  alert alert-warning alert-dismissible fade show" role="alert">
            <span class="alert-text text-white">
              <?php echo e($errors->first()); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <?php if(session('success')): ?>
          <div class="m-3  alert alert-success alert-dismissible fade show" id="alert-success" role="alert">
            <span class="alert-text text-white">
              <?php echo e(session('success')); ?></span>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
              <i class="fa fa-close" aria-hidden="true"></i>
            </button>
          </div>
          <?php endif; ?>
          <table class="table table-flush" id="data-list">
            <thead class="thead-light">
              <tr>
                <th>ID</th>
                <th>Language</th>
                <th>Question</th>
                <th>Answer</th>
                <th>ACTION</th>
              </tr>
            </thead>
            <tbody>
              <?php if(count($data) > 0): ?>
              <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr id="<?php echo e($item->id); ?>">
                <td class="text-sm">
                  <div class="form-check my-auto">
                  <?php echo e($item->id); ?>

                  </div>
                </td>
                <td class="text-sm"><?php echo e($item->lang); ?></td>
                <td class="text-sm"><?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->question), 30, $end='...')); ?></td>
                <td class="text-sm"><?php echo e(\Illuminate\Support\Str::limit(strip_tags($item->answer), 30, $end='...')); ?></td>
                <td class="text-sm"><?php echo date('d-M-y H:i:s',strtotime($item->created_at)); ?></td>
                <td class="text-sm">
                  <a href="#" class="mx-3 editFaq" id="<?php echo e($item->id); ?>" data-bs-toggle="tooltip" data-bs-original-title="Edit">
                    <i class="fas fa-edit text-success"></i>
                  </a>
                  <a href="#"  data-id="faq"  id="<?php echo e($item->id); ?>"  class="mx-3 delete" data-bs-toggle="tooltip" data-bs-original-title="Delete">
                    <i class="fas fa-trash text-danger"></i>
                  </a>
                </td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>no content </tr>
              <?php endif; ?>
            </tbody>
          </table>

          <?php echo e($data->links('components.paginate')); ?>

        </div>
      </div>
    </div>
  </div>
</div>

<?php echo $__env->make('modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script src="<?php echo e(URL::asset('assets/js/plugins/datatables.js')); ?>"></script>
<script src="../../assets/js/plugins/sweetalert.min.js"></script>
<script src="../../assets/js/plugins/action.js"></script>
<script>
  if (document.getElementById('data-list')) {
    const dataTableSearch = new simpleDatatables.DataTable("#data-list", {
      searchable: true,
      fixedHeight: true,
      perPage: 15,
      labels: {
        placeholder: "Search...",
        perPage: "Show {select} entries",
        noRows: "No entries found",
        info: "Showing <?php echo e($data->firstItem()); ?> to <?php echo e($data->lastItem()); ?> of <?php echo e($data->total()); ?> entries"
      },
    });

    document.querySelectorAll(".export").forEach(function(el) {
      el.addEventListener("click", function(e) {
        var type = el.dataset.type;

        var data = {
          type: type,
          filename: "alias-" + type,
        };

        if (type === "csv") {
          data.columnDelimiter = "|";
        }

        dataTableSearch.export(data);
      });
    });
  };
</script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.5.1/jquery.min.js"></script>
<script>
  $(document).ready(function() {
    $("#alert-success").delay(3000).slideUp(300);
  });
  
    $("body").on("click",".addFaq", function () {
        $("#faqModal").modal('show');
        
         var roles = <?php echo json_encode($lang->toArray()); ?>;
                $.each(roles, function(i, item) {
                         $('#faq_action_type')
                  .append($('<option>', { value : item.code })
                  .text(item.title));
                }); 
    });
    
    
    
    $("body").on("click", ".editFaq", function () {
        var current_object = $(this);
        var link = window.location.origin;
        id=current_object.attr('id');
         $.ajax({
            url: 'faq/edit/'+id,
            type: "GET",

            success: function (data) {
                 $("#faqupdateModal").modal('show');
                 $("#faqid").val(data[0]['id']);
                 $("#question").val(data[0]['question']);
                 $("#answer").val(data[0]['answer']);
                 
                  var roles = <?php echo json_encode($lang->toArray()); ?>;
                $.each(roles, function(i, item) {
                         $('#faq_select_action_type')
                  .append($('<option>', { value : item.code })
                  .text(item.title));
                }); 
                 
                  $('#faq_select_action_type option[value="'+ data[0]['lang'] +'"]').attr("selected", "selected");
      
                console.log(data[0]['id']);
                },
            });

    });
  
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('user_type.auth', ['parentFolder' => 'pages', 'childFolder' => ''], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Users/souheiljabbour/Sites/lebara.test/resources/views/setting/faq/index.blade.php ENDPATH**/ ?>